% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.omicsData.R
\name{as.metabData}
\alias{as.metabData}
\title{Create pmartR Object of Class metabData}
\usage{
as.metabData(
  e_data,
  f_data,
  e_meta = NULL,
  edata_cname,
  fdata_cname,
  emeta_cname = NULL,
  techrep_cname = NULL,
  ...
)
}
\arguments{
\item{e_data}{a \eqn{p \times n + 1} data frame of expression data, where
\eqn{p} is the number of metabolites observed and \eqn{n} is the number of
samples. Each row corresponds to data for one metabolite. One column
specifying a unique identifier for each metabolite (row) must be present.}

\item{f_data}{a data frame with \eqn{n} rows. Each row corresponds to a
sample with one column giving the unique sample identifiers found in e_data
column names and other columns providing qualitative and/or quantitative
traits of each sample.}

\item{e_meta}{an optional data frame with \eqn{p} rows. Each row corresponds
to a metabolite with one column giving metabolite names (must be named the
same as the column in \code{e_data}) and other columns giving meta
information.}

\item{edata_cname}{character string specifying the name of the column
containing the metabolite identifiers in \code{e_data} and \code{e_meta}
(if applicable).}

\item{fdata_cname}{character string specifying the name of the column
containing the sample identifiers in \code{f_data}.}

\item{emeta_cname}{character string specifying the name of the column
containing the mapped identifiers in \code{e_meta} (if applicable).
Defaults to NULL. Can be the same as edata_cname, if desired. If \code{e_meta} is NULL, then either do not specify
\code{emeta_cname} or specify it as NULL.}

\item{techrep_cname}{character string specifying the name of the column in
\code{f_data} that specifies which samples are technical replicates. This column is used to
collapse the data when \code{combine_techreps} is called on this object.
Defaults to NULL (no technical replicates).}

\item{...}{further arguments}
}
\value{
Object of class metabData
}
\description{
Converts several data frames of metabolomic data to an
object of the class 'metabData'. Objects of the class 'metabData' are lists
with two obligatory components, \code{e_data} and \code{f_data}. An optional
list component, \code{e_meta}, is used if analysis or visualization at other
levels (e.g. metabolite identification) is also desired.
}
\details{
Objects of class 'metabData' contain some attributes that are
  referenced by downstream functions. These attributes can be changed from
  their default value by manual specification. A list of these attributes as
  well as their default values are as follows: \tabular{ll}{ data_scale \tab
  Scale of the data provided in \code{e_data}. Acceptable values are 'log2',
  'log10', 'log', and 'abundance', which indicate data is log base 2, base
  10, natural log, or raw abundance, respectively. Default is
  'abundance'. \cr \tab \cr is_normalized \tab A logical argument, specifying
  whether the data has been normalized or not. Default value is FALSE. \cr
  \tab \cr norm_info \tab Default value is an empty list, which will be
  populated with a single named element \code{is_normalized = is_normalized}.
  When a normalization is applied to the data, this becomes populated with a
  list containing the normalization function, normalization subset and subset
  parameters, the location and scale parameters used to normalize the data,
  and the location and scale parameters used to backtransform the data (if
  applicable). \cr \tab \cr data_types \tab Character string describing the type of data, most commonly used for lipidomic data (lipidData objects) or NMR data (nmrData objects) but available for other data classes as well. Default value is NULL. \cr } Computed
  values included in the \code{data_info} attribute are as follows:
  \tabular{ll}{ num_edata \tab The number of unique \code{edata_cname}
  entries.\cr \tab \cr num_miss_obs \tab The number of missing
  observations.\cr \tab \cr num_emeta \tab The number of unique
  \code{emeta_cname} entries. \cr \tab \cr prop_missing \tab The proportion
  of \code{e_data} values that are NA. \cr \tab \cr num_samps \tab The number
  of samples that make up the columns of \code{e_data}.\cr \tab \cr meta_info
  \tab A logical argument, specifying where the \code{e_meta} is provided.\cr
  \tab \cr }
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mymetabData <- as.metabData(
  e_data = metab_edata,
  f_data = metab_fdata,
  edata_cname = "Metabolite",
  fdata_cname = "SampleID"
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{as.lipidData}}

\code{\link{as.nmrData}}
}
\author{
Lisa Bramer, Kelly Stratton
}
