% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_pb_methods.R
\name{pibble_methods}
\alias{pibble_methods}
\alias{mutate.tbl_pb}
\alias{distinct.tbl_pb}
\alias{group_by.tbl_pb}
\alias{ungroup.tbl_pb}
\alias{select.tbl_pb}
\alias{rename.tbl_pb}
\alias{summarize.tbl_pb}
\alias{summarise.tbl_pb}
\alias{transmute.tbl_pb}
\title{pibble methods}
\usage{
\method{mutate}{tbl_pb}(.data, ...)

\method{distinct}{tbl_pb}(.data, ..., .keep_all = FALSE)

\method{group_by}{tbl_pb}(.data, ...)

\method{ungroup}{tbl_pb}(x, ...)

\method{select}{tbl_pb}(.data, ...)

\method{rename}{tbl_pb}(.data, ...)

\method{summarize}{tbl_pb}(.data, ...)

\method{summarise}{tbl_pb}(.data, ...)

\method{transmute}{tbl_pb}(.data, ...)
}
\arguments{
\item{.data, x}{These functions take a \code{tbl_pb} (i.e. \code{pibble}) object as input}

\item{.keep_all, ...}{Other parameters to be passed to the relevant functions}
}
\description{
These are variants of existing functions that are designed to retain the \code{pibble} status of the object, as well as its \code{.i}, \code{.t}, and \code{.d} attributes.
}
\details{
Some functions that already preserve \code{pibble} status and so don't need special methods include:

\code{dplyr::add_row(), tibble:add_column(), dplyr::arrange(), dplyr::bind_cols(), dplyr::filter(), dplyr::sample_frac(), dplyr::sample_n(), dplyr::slice(), dplyr::top_n}

as well as all scoped variants (\code{_all}, \code{_if}, \code{_at}) of \code{dplyr} functions.

\code{dplyr::bind_rows()} is currently not supported. If you use \code{dplyr::bind_rows()} you should pipe it to \code{as_pibble()}.

Any function that takes two data frames/tibbles as inputs will retain the panel structure of the \emph{first} argument.

If a function is not on the above list or elsewhere in this help file, then you may need to re-\code{as_pibble} your object after using the function.
}
