% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_dir.R
\name{metar_dir}
\alias{metar_dir}
\title{Get wind direction.}
\usage{
metar_dir(x, numeric_only = FALSE, check = FALSE)
}
\arguments{
\item{x}{character vector; a METAR weather report or reports.}

\item{numeric_only}{logical; the default value is FALSE and information about variability will be included.
If TRUE only a numeric value of direction will be returned.}

\item{check}{logical; if TRUE the syntax of METAR reports will be checked.}
}
\value{
a numeric vector with a wind direction in degrees.
}
\description{
Extract a wind direction value from METAR weather report.
}
\examples{
metar_dir("EPWA 281830Z 18009KT 140V200 9999 SCT037 03/M01 Q1008 NOSIG")
metar_dir("CYUL 281800Z 13008KT 30SM BKN240 01/M06 A3005 RMK CI5 SLP180",
numeric_only = TRUE)
metar_dir("201711271930 METAR LEMD 271930Z 02002KT CAVOK 04/M03 Q1025")

}
