% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ss_3cmt_linear_bolus.R
\name{calc_ss_3cmt_linear_bolus}
\alias{calc_ss_3cmt_linear_bolus}
\title{Calculate C(t) for a 3-compartment linear model at steady state with IV bolus dosing}
\usage{
calc_ss_3cmt_linear_bolus(tad, CL, V1, V2, V3, Q2, Q3, dose, tau)
}
\arguments{
\item{tad}{Time after last dose (h)}

\item{CL}{Clearance (L/h)}

\item{V1}{Central volume of distribution (L)}

\item{V2}{First peripheral volume of distribution (L)}

\item{V3}{Second peripheral volume of distribution (L)}

\item{Q2}{Intercompartmental clearance between V1 and V2 (L/h)}

\item{Q3}{Intercompartmental clearance between V2 and V3 (L/h)}

\item{dose}{Dose}

\item{tau}{Dosing interval (h)}
}
\value{
Concentration of drug at requested time (\code{tad}) at steady state, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 3-compartment linear model at steady state with IV bolus dosing
}
\examples{
Ctrough <- calc_ss_3cmt_linear_bolus(t = 11.75, CL = 3.5, V1 = 20, V2 = 500,
    V3 = 200, Q2 = 0.5, Q3 = 0.05, dose = 100, tau=24)

}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{http://lixoft.com/wp-content/uploads/2016/03/PKPDlibrary.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
