% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.r
\name{combine_match_general_to_trades}
\alias{combine_match_general_to_trades}
\title{Match general to trades directory records}
\usage{
combine_match_general_to_trades(
  trades_directory,
  general_directory,
  progress = TRUE,
  verbose = FALSE,
  distance = TRUE,
  matches = TRUE,
  ...
)
}
\arguments{
\item{trades_directory}{A Scottish post office trades directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{surname}, \code{forename}, \code{address.trade.number}, \code{address.trade.body}.}

\item{general_directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{surname}, \code{forename}, \code{address.trade.number}, \code{address.trade.body},
\code{address.house.number}, \code{address.house.body}.}

\item{progress}{Whether progress should be shown (\code{TRUE}) or not (\code{FALSE}).}

\item{verbose}{Whether the function should be executed silently (\code{FALSE}) or
not (\code{TRUE}).}

\item{distance}{Whether (\code{TRUE}) or not (\code{FALSE}) a column 'distance' showing
the string distance between records used for their matching and calculated
using the method specified below should be added to the output dataset.}

\item{matches}{Whether (\code{TRUE}) or not (\code{FALSE}) a column 'match' showing
general directory matches' name and address(es) should be added to the
output dataset.}

\item{...}{Further arguments to be passed down to
\code{\link[fuzzyjoin]{stringdist_left_join}}.}
}
\value{
A \code{\link[tibble]{tibble}}; columns include at least \code{surname},
\code{forename}, \code{address.trade.number}, \code{address.trade.body},
\code{address.house.number}, \code{address.house.body}.
}
\description{
Attempts to complement Scottish post office trades directory data.frame with
house address information from the Scottish post office general directory
data.frame provided by matching records from the two datasets using the
distance metric specified.
}
\examples{
trades_directory <- tibble::tibble(
  page = rep("71", 3L),
  rank = c("135", "326", "586"),
  surname = c("Abbott", "Abercromby", "Blair"),
  forename = c("William", "Alexander", "John Hugh"),
  occupation = c("Wine and spirit merchant", "Baker", "Victualler"),
  type = rep("OWN ACCOUNT", 3L),
  address.trade.number = c("18, 20", "12", "280"),
  address.trade.body = c("London Road", "Dixon Place", "High Street")
)
general_directory <- tibble::tibble(
  page = rep("71", 2L),
  surname = c("Abbott", "Abercromby"), forename = c("William", "Alexander"),
  occupation = c("Wine and spirit merchant", "Baker"),
  address.trade.number = c("18, 20", ""),
  address.house.number = c("136", "29"),
  address.trade.body = c("London Road", "Dixon Place"),
  address.house.body = c("Queen Square", "Anderston Quay")
)
combine_match_general_to_trades(
 trades_directory, general_directory, progress = TRUE, verbose = FALSE,
 distance = TRUE, method = "osa", max_dist = 5
)

}
