% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poems-package.R
\docType{package}
\name{poems-package}
\alias{poems-package}
\title{poems: Pattern-Oriented Ensemble Modeling System}
\description{
A framework of interoperable R6 classes (Chang, 2020, \url{https://CRAN.R-project.org/package=R6}) for building ensembles of viable models via the pattern-oriented modeling (POM) approach (Grimm et al.,2005, \doi{10.1126/science.1116681}). The package includes classes for encapsulating and generating model parameters, and managing the POM workflow. The workflow includes: model setup; generating model parameters via Latin hyper-cube sampling (Iman & Conover, 1980, \doi{10.1080/03610928008827996}); running multiple sampled model simulations; collating summary results; and validating and selecting an ensemble of models that best match known patterns. By default, model validation and selection utilizes an approximate Bayesian computation (ABC) approach (Beaumont et al., 2002, \doi{10.1093/genetics/162.4.2025}), although alternative user-defined functionality could be employed. The package includes a spatially explicit demographic population model simulation engine, which incorporates default functionality for density dependence, correlated environmental stochasticity, stage-based transitions, and distance-based dispersal. The user may customize the simulator by defining functionality for translocations, harvesting, mortality, and other processes, as well as defining the sequence order for the simulator processes. The framework could also be adapted for use with other model simulators by utilizing its extendable (inheritable) base classes.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/GlobalEcologyLab/poems}
  \item \url{https://globalecologylab.github.io/poems/}
  \item Report bugs at \url{https://github.com/GlobalEcologyLab/poems/issues}
}

}
\author{
\strong{Maintainer}: July Pilowsky \email{pilowskyj@caryinstitute.org} (\href{https://orcid.org/0000-0002-6376-2585}{ORCID})

Authors:
\itemize{
  \item Sean Haythorne \email{sean.haythorne@unimelb.edu.au}
  \item Damien Fordham \email{damien.fordham@adelaide.edu.au}
  \item Stuart Brown \email{stuart.brown@sa.gov.au} (\href{https://orcid.org/0000-0002-0669-1418}{ORCID})
  \item Jessie Buettel \email{jessie.buettel@utas.edu.au}
  \item Barry Brook \email{barry.brook@utas.edu.au}
}

}
\keyword{internal}
