% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.pogit}
\alias{print.summary.pogit}
\alias{summary.pogit}
\title{Summary for posterior of a \code{pogit} object}
\usage{
\method{summary}{pogit}(object, IAT = FALSE, printRes = FALSE, ...)

\method{print}{summary.pogit}(x, ...)
}
\arguments{
\item{object}{an object of class \code{pogit}}

\item{IAT}{if \code{TRUE}, integrated autocorrelation times (IAT) and
effective samples sizes (ESS) of the MCMC samples are computed (see
details); defaults to \code{FALSE}.}

\item{printRes}{if \code{TRUE}, model averaged posterior means for the
reporting probabilities and risks are computed for the Pogit model;
defaults to \code{FALSE}.}

\item{...}{further arguments passed to or from other methods (not used)}

\item{x}{a \code{summary.pogit} object produced by \code{summary.pogit()}}
}
\value{
an object of class \code{summary.pogit}
}
\description{
Returns basic information about the model and the priors, MCMC details and
(model averaged) posterior means with 95\%-HPD intervals for the regression
effects and estimated posterior inclusion probabilities.
}
\details{
To assess mixing and efficiency of MCMC sampling, the effective sample size
(ESS) and the integrated autocorrelation time (IAT) are computed. ESS
estimates the equivalent number of independent draws corresponding to the
dependent MCMC draws and is defined as ESS = \eqn{M}/\eqn{\tau}, where \eqn{\tau}
is the IAT and \eqn{M} is the number of MCMC iterations after the burn-in phase.
IAT is computed as \eqn{\tau = 1 + 2 \sum_{k=1}^K \rho(k)}
using the initial monotone sequence estimator (Geyer, 1992) for K and
\eqn{\rho(k)} is the empirical autocorrelation at lag \eqn{k}.
}
\author{
Michaela Dvorzak <m.dvorzak@gmx.at>
}
\references{
Geyer, C. J. (1992). Practical Markov Chain Monte Carlo.
 \emph{Statistical Science}, \strong{7}, 473-483.
}

