% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emailing.R
\name{email_create}
\alias{email_create}
\title{Create an email object from a \strong{pointblank} \emph{agent} or \emph{informant}}
\usage{
email_create(
  x,
  msg_header = NULL,
  msg_body = stock_msg_body(),
  msg_footer = stock_msg_footer()
)
}
\arguments{
\item{x}{A \strong{pointblank} \emph{agent}, an \emph{agent} x-list, or a \strong{pointblank}
\emph{informant}. The x-list object can be created with the \code{\link[=get_agent_x_list]{get_agent_x_list()}}
function. It is recommended that the option \code{i = NULL} be used with
\code{\link[=get_agent_x_list]{get_agent_x_list()}} if supplying an x-list as \code{x}. Furthermore, The option
\code{generate_report = TRUE} could be used with \code{\link[=create_agent]{create_agent()}} so that the
agent report is available within the email.}

\item{msg_header, msg_body, msg_footer}{Content for the header, body, and
footer components of the HTML email message.}
}
\value{
A \strong{blastula} \code{email_message} object.
}
\description{
The \code{email_create()} function produces an email message object that could be
sent using the \strong{blastula} package. The \code{x} that we need for this could
either be a \strong{pointblank} agent, the \emph{agent} x-list (produced from the
\emph{agent} with the \code{\link[=get_agent_x_list]{get_agent_x_list()}} function), or a \strong{pointblank}
\emph{informant}. In all cases, the email message will appear in the Viewer and a
\strong{blastula} \code{email_message} object will be returned.
}
\section{Function ID}{

4-2
}

\examples{
if (interactive()) {

# Create an `action_levels()` list
# with absolute values for the
# `warn`, and `notify` states (with
# thresholds of 1 and 2 'fail' units)
al <- 
  action_levels(
    warn_at = 1,
    notify_at = 2
  )

# In a workflow that involves an
# `agent` object, we can make use of
# the `end_fns` argument and
# programmatically email the report
# with the `email_blast()` function,
# however, an alternate workflow is to
# produce the email object and choose
# to send outside of the pointblank API;
# the `email_create()` function lets
# us do this with an `agent` object
email_object_1 <-
  create_agent(
    tbl = small_table,
    tbl_name = "small_table",
    label = "An example.",
    actions = al
  ) \%>\%
  col_vals_gt(vars(a), value = 1) \%>\%
  col_vals_lt(vars(a), value = 7) \%>\%
  interrogate() \%>\%
  email_create()

# We can view the HTML email just
# by printing `email_object`; it
# should appear in the Viewer

# The `email_create()` function can
# also be used on an agent x-list to
# get the same email message object
email_object_2 <-
  create_agent(
    tbl = small_table,
    tbl_name = "small_table",
    label = "An example.",
    actions = al
  ) \%>\%
  col_vals_gt(vars(a), value = 5) \%>\%
  col_vals_lt(vars(b), value = 5) \%>\%
  interrogate() \%>\%
  get_agent_x_list() \%>\%
  email_create()

# An information report that's
# produced by the informant can
# made into an email message object;
# let's create an informant and use
# `email_create()`
email_object_3 <-
  create_informant(
    tbl = small_table,
    tbl_name = "small_table",
    label = "An example."
  ) \%>\%
  info_tabular(
    info = "A simple table in the
    *Examples* section of the function
    called `email_create()`."
  ) \%>\%
  info_columns(
    columns = vars(a),
    info = "Numbers. On the high side."
  ) \%>\%
  info_columns(
    columns = vars(b),
    info = "Lower numbers. Zeroes, even."
  ) \%>\%
  incorporate() \%>\%
  email_create()

}

}
\seealso{
Other Emailing: 
\code{\link{email_blast}()},
\code{\link{stock_msg_body}()},
\code{\link{stock_msg_footer}()}
}
\concept{Emailing}
