% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_columns_from_tbl}
\alias{info_columns_from_tbl}
\title{Add column information from another data table}
\usage{
info_columns_from_tbl(x, tbl, .add = TRUE)
}
\arguments{
\item{x}{An informant object of class \code{ptblank_informant}.}

\item{tbl}{The two-column data frame which contains metadata about the target
table in the informant object.}

\item{.add}{Should new text be added to existing text? This is \code{TRUE} by
default; setting to \code{FALSE} replaces any existing text for the \code{"info"}
property.}
}
\value{
A \code{ptblank_informant} object.
}
\description{
The \code{info_columns_from_tbl()} function is a wrapper around the
\code{\link[=info_columns]{info_columns()}} function and is useful if you wish to apply \emph{info text} to
columns where that information already exists in a data frame (or in some
form that can readily be coaxed into a data frame). The form of the input
\code{tbl} (the one that contains column metadata) has a few basic requirements:
\itemize{
\item the data frame must have two columns
\item both columns must be of class \code{character}
\item the first column should contain column names and the second should contain
the \emph{info text}
}

Each column that matches across tables (i.e., the \code{tbl} and the target table
of the informant) will have a new entry for the \code{"info"} property. Empty or
missing info text will be pruned from \code{tbl}.
}
\section{Function ID}{

3-3
}

\examples{
# Create a pointblank `informant`
# object with `create_informant()`;
# we can specify a `tbl` with the
# `~` followed by a statement that
# gets the `game_revenue` dataset
informant <- 
  create_informant(
    tbl = ~ game_revenue,
    tbl_name = "game_revenue",
    label = "An example."
  )

# We can add *info text* to describe
# the columns in the table by using
# information in another table; the
# `game_revenue_info` dataset contains
# metadata for `game_revenue`

game_revenue_info

# The `info_columns_from_tbl()`
# function takes a table object
# where the first column has the
# column names and the second
# contains the *info text*
informant <-
  informant \%>\%
  info_columns_from_tbl(
    tbl = game_revenue_info
  )

# We can continue to add more *info
# text* since the process is additive;
# the `info_columns_from_tbl()`
# function populates the `info`
# subsection
informant <-
  informant \%>\%
  info_columns(
    columns = "item_revenue",
    info = "Revenue reported in USD."
  ) \%>\%
  info_columns(
    columns = "acquisition",
    `top list` = "{top5_aq}"
  ) \%>\%
  info_snippet(
    snippet_name = "top5_aq",
    fn = snip_list(column = "acquisition")
  ) \%>\%
  incorporate()

}
\seealso{
The \code{\link[=info_columns]{info_columns()}} function, which allows for manual entry of
\emph{info text}.

Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()},
\code{\link{snip_highest}()},
\code{\link{snip_list}()},
\code{\link{snip_lowest}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
