% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_is_numeric.R
\name{col_is_numeric}
\alias{col_is_numeric}
\alias{expect_col_is_numeric}
\alias{test_col_is_numeric}
\title{Do the columns contain numeric values?}
\usage{
col_is_numeric(x, columns, actions = NULL, brief = NULL, active = TRUE)

expect_col_is_numeric(object, columns, threshold = 1)

test_col_is_numeric(object, columns, threshold = 1)
}
\arguments{
\item{x}{A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), or, an agent object of
class \code{ptblank_agent} that can be created with \code{\link[=create_agent]{create_agent()}}.}

\item{columns}{The column (or a set of columns, provided as a character
vector) to which this validation should be applied.}

\item{actions}{A list containing threshold levels so that the validation step
can react accordingly when exceeding the set levels. This is to be created
with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{brief}{An optional, text-based description for the validation step.}

\item{active}{A logical value indicating whether the validation step should
be active. If the step function is working with an agent, \code{FALSE} will make
the validation step inactive (still reporting its presence and keeping
indexes for the steps unchanged). If the step function will be operating
directly on data, then any step with \code{active = FALSE} will simply pass the
data through with no validation whatsoever. The default for this is \code{TRUE}.}

\item{object}{A data frame or tibble (\code{tbl_df} or \code{tbl_dbi}) that serves as
the target table for the expectation function.}

\item{threshold}{A simple failure threshold value for use with the
expectation function. By default, this is set to \code{1} meaning that any
single unit of failure in data validation results in an overall test
failure. Whole numbers beyond \code{1} indicate that any failing units up to
that absolute threshold value will result in a succeeding \strong{testthat}
test. Likewise, fractional values (between \code{0} and \code{1}) act as a
proportional failure threshold.}
}
\value{
For the validation function, the return value is either a
\code{ptblank_agent} object or a table object (depending on whether an agent
object or a table was passed to \code{x}). The expectation function invisibly
returns its input but, in the context of testing data, the function is
called primarily for its potential side-effects (e.g., signaling failure).
The test function returns a logical value.
}
\description{
The \code{col_is_numeric()} validation function, the \code{expect_col_is_numeric()}
expectation function, and the \code{test_col_is_numeric()} test function all check
whether one or more columns in a table is of the numeric type. Like many of
the \verb{col_is_*()}-type functions in \strong{pointblank}, the only requirement is a
specification of the column names. The validation function can be used
directly on a data table or with an \emph{agent} object (technically, a
\code{ptblank_agent} object) whereas the expectation and test functions can only
be used with a data table. The types of data tables that can be used include
data frames, tibbles, and even database tables of \code{tbl_dbi} class. Each
validation step or expectation will operate over a single test unit, which is
whether the column is a numeric-type column or not.
}
\details{
If providing multiple column names, the result will be an expansion of
validation steps to that number of column names (e.g., \code{vars(col_a, col_b)}
will result in the entry of two validation steps). Aside from column names in
quotes and in \code{vars()}, \strong{tidyselect} helper functions are available for
specifying columns. They are: \code{starts_with()}, \code{ends_with()}, \code{contains()},
\code{matches()}, and \code{everything()}.

Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation function, takes a specially-crafted list
object that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that
function's documentation for the lowdown on how to create reactions to
above-threshold failure levels in validation. The basic gist is that you'll
want at least a single threshold level (specified as either the fraction of
test units failed, or, an absolute value), often using the \code{warn_at}
argument. This is especially true when \code{x} is a table object because,
otherwise, nothing happens. For the \verb{col_is_*()}-type functions, using
\code{action_levels(warn_at = 1)} or \code{action_levels(stop_at = 1)} are good choices
depending on the situation (the first produces a warning, the other
\code{stop()}s).

Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.
}
\section{Function ID}{

2-17
}

\examples{
# The `small_table` dataset in the
# package has a `d` column that is
# known to be numeric; the following
# examples will validate that that
# column is indeed of the `numeric`
# class

# A: Using an `agent` with validation
#    functions and then `interrogate()`

# Validate that the column `d` has
# the `numeric` class
agent <-
  create_agent(small_table) \%>\%
  col_is_numeric(vars(d)) \%>\%
  interrogate()
  
# Determine if this validation
# had no failing test units (1)
all_passed(agent)

# Calling `agent` in the console
# prints the agent's report; but we
# can get a `gt_tbl` object directly
# with `get_agent_report(agent)`

# B: Using the validation function
#    directly on the data (no `agent`)

# This way of using validation functions
# acts as a data filter: data is passed
# through but should `stop()` if there
# is a single test unit failing; the
# behavior of side effects can be
# customized with the `actions` option
small_table \%>\%
  col_is_numeric(vars(d)) \%>\%
  dplyr::slice(1:5)

# C: Using the expectation function

# With the `expect_*()` form, we would
# typically perform one validation at a
# time; this is primarily used in
# testthat tests
expect_col_is_numeric(
  small_table, vars(d)
)

# D: Using the test function

# With the `test_*()` form, we should
# get a single logical value returned
# to us
small_table \%>\%
  test_col_is_numeric(vars(d))

}
\seealso{
Other validation functions: 
\code{\link{col_exists}()},
\code{\link{col_is_character}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_posix}()},
\code{\link{col_schema_match}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_expr}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_not_between}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{conjointly}()},
\code{\link{rows_distinct}()}
}
\concept{validation functions}
