% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_yaml.R
\name{agent_yaml_show_exprs}
\alias{agent_yaml_show_exprs}
\title{Display \emph{pointblank} expressions using a YAML file with a validation plan}
\usage{
agent_yaml_show_exprs(path)
}
\arguments{
\item{path}{A path to a YAML file that specifies a validation plan for an
\emph{agent}.}
}
\description{
The \code{agent_yaml_show_exprs()} function follows the specifications of a
\strong{pointblank} YAML file to generate and show the \strong{pointblank} expressions
for generating the described validation plan. The expressions are shown in
the console, providing an opportunity to copy the statements and extend as
needed. A \strong{pointblank} YAML file can itself be generated by using the
\code{\link[=agent_yaml_write]{agent_yaml_write()}} function with a pre-existing \emph{agent}, or, it can be
carefully written by hand.
}
\section{Function ID}{

7-5
}

\examples{
# Let's create a validation plan for the
# data quality analysis of the `small_table`
# dataset; we need an agent and its
# table-reading function enables retrieval
# of the target table
agent <- 
  create_agent(
    read_fn = ~small_table,
    name = "example",
    actions = action_levels(
      warn_at = 0.10,
      stop_at = 0.25,
      notify_at = 0.35
    )
  ) \%>\%
  col_exists(vars(date, date_time)) \%>\%
  col_vals_regex(
    vars(b), "[0-9]-[a-z]{3}-[0-9]{3}"
  ) \%>\%
  rows_distinct() \%>\%
  col_vals_gt(vars(d), 100) \%>\%
  col_vals_lte(vars(c), 5)

# The agent can be written to a pointblank
# YAML file with `agent_yaml_write()`
# agent_yaml_write(agent, filename = "x.yml")

# The 'x.yml' file is available in the package
# through `system.file()`
yml_file <- 
  system.file("x.yml", package = "pointblank")

# At a later time, the YAML file can
# be read into a new agent with the
# `agent_yaml_read()` function
agent <- agent_yaml_read(path = yml_file)

class(agent)

# To get a sense of which expressions are
# being used to generate the new agent, we
# can use `agent_yaml_show_exprs()`
agent_yaml_show_exprs(path = yml_file)
  
}
\seealso{
Other pointblank YAML: 
\code{\link{agent_yaml_interrogate}()},
\code{\link{agent_yaml_read}()},
\code{\link{agent_yaml_string}()},
\code{\link{agent_yaml_write}()}
}
\concept{pointblank YAML}
