% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{factors.single}
\alias{factors.single}
\title{Get latent factors for a new user given her item counts}
\usage{
factors.single(
  model,
  X,
  l2_reg = 1e+05,
  l1_reg = 0,
  nupd = 100,
  weight_mult = 1
)
}
\arguments{
\item{model}{Poisson factorization model as returned by `poismf`.}

\item{X}{Data with the non-zero item indices and counts for this new user. Can be
passed as a sparse vector from package `Matrix` (`Matrix::dsparseVector`, which can
be created from indices and values through function `Matrix::sparseVector`), or
as a `data.frame`, in which case will take the first column as the item/column indices
(numeration starting at 1) and the second column as the counts. If `X` passed to
`poismf` was a `data.frame`, `X` here must also be a `data.frame`.}

\item{l2_reg}{Strength of L2 regularization to use for optimizing the new factors. Note
that these are obtained through a conjugate-gradient method instead of
proximal gradient, which works better with smaller regularization values.}

\item{l1_reg}{Strength of the L1 regularization (see description of argument above).
Not recommended.}

\item{nupd}{Maximum number of conjugate gradient updates.}

\item{weight_mult}{Weight multiplier for the positive entries over the missing entries.
Not recommended.}
}
\value{
Vector of dimensionality `model$k` with the latent factors for the user,
given the input data.
}
\description{
This is similar to obtaining topics for a document in LDA. See also
function \link{factors} for getting factors for multiple users/rows at
a time.

This function works with one user at a time, and will use a
conjugate gradient approach regardless of how the model was fit.
As well, it will use the regularization parameter passed here instead of
the original one from the model, which means the obtained factors might
not end up being in the same scale as the original ones which are stored
under `model$A`. See function \link{factors} for a different approach using
the same method with which the model was fit.

Be aware that the proximal gradient method, which is the default for fitting
the model and which doesn't try to reach global optima, requires larger
regularization, whereas the conjugate gradient method, which tries to find the
global optimum, will fail to fit with too larger regularization (i.e. the
optimal will be all-zeros).
}
\details{
The factors are initialized to the mean of each column in the fitted model.
}
\seealso{
\link{factors} \link{topN.new}
}
