% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poker.R
\name{assignToPlayers}
\alias{assignToPlayers}
\title{assignToPlayers}
\usage{
assignToPlayers(nPlayers, position, y)
}
\arguments{
\item{nPlayers}{number of hands to deal as
integer in \{2, ... , 9\}}

\item{position}{dealer position as    integer in \{2, ..., nPlayers\}}

\item{y}{cards dealt as                    vector[2*nPlayers+5] in \{1, 2, ..., 52\}}
}
\value{
\tabular{ll}{players :	the hole cards in absolute position \tab
											as matrix[nPlayers, 4] in \{1, 2, ..., 52\} \cr \tab
											col1: rank of card 1 in \{2, ... , 14\} \cr \tab
											col2: suit of card 1 in \{1, 2, 3, 4\} \cr \tab
											col3: rank of card 2 \cr \tab
											col4: suit of card 2}
}
\description{
A standard deal situation beginnng the deal at the left of the dealer.
}
\examples{
assignToPlayers(9,9,1:23)
assignToPlayers(9,1,1:23)
assignToPlayers(9,1,c(1:17,24,48:52))
}
\seealso{
\code{\link{dotTransformToAbsolute}}
}
