% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_millisecond}
\alias{ExprDT_millisecond}
\alias{(Expr)$dt$millisecond}
\title{Millisecond}
\format{
function
}
\value{
Expr of millisecond as Int64
}
\description{
Extract milliseconds from underlying Datetime representation.
Applies to Datetime columns.
}
\examples{
pl$DataFrame(date = pl$date_range(
  as.numeric(as.POSIXct("2001-1-1")) * 1E6 + 456789, # manually convert to us
  as.numeric(as.POSIXct("2001-1-1 00:00:6")) * 1E6,
  interval = "2s654321us",
  time_unit = "us", # instruct polars input is us, and store as us
  lazy = FALSE
))$with_columns(
  pl$col("date")$cast(pl$Int64)$alias("datetime int64"),
  pl$col("date")$dt$millisecond()$alias("millisecond")
)
}
\keyword{ExprDT}
