% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_quarter}
\alias{ExprDT_quarter}
\alias{(Expr)$dt$quarter}
\title{Quarter}
\format{
function
}
\value{
Expr of quarter as UInt32
}
\description{
Extract quarter from underlying Date representation.
Applies to Date and Datetime columns.
Returns the quarter ranging from 1 to 4.
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    as.Date("2020-12-25"),
    as.Date("2021-1-05"),
    interval = "1d",
    time_zone = "GMT",
    lazy = FALSE
  )
)
df$with_columns(
  pl$col("date")$dt$quarter()$alias("quarter")
)
}
\keyword{ExprDT}
