% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_skew}
\alias{Expr_skew}
\alias{skew}
\title{Skewness}
\usage{
Expr_skew(bias = TRUE)
}
\arguments{
\item{bias}{If False, then the calculations are corrected for statistical bias.}
}
\value{
Expr
}
\description{
Compute the sample skewness of a data set.
}
\details{
For normally distributed data, the skewness should be about zero. For
unimodal continuous distributions, a skewness value greater than zero means
that there is more weight in the right tail of the distribution. The
function \code{skewtest} can be used to determine if the skewness value
is close enough to zero, statistically speaking.

See scipy.stats for more information.
\subsection{Notes}{

The sample skewness is computed as the Fisher-Pearson coefficient
of skewness, i.e.

\eqn{ g_1=\frac{m_3}{m_2^{3/2}}}

where

\eqn{ m_i=\frac{1}{N}\sum_{n=1}^N(x[n]-\bar{x})^i}

is the biased sample :math:\verb{i\\texttt\{th\}} central moment, and \eqn{\bar{x}} is
the sample mean.  If \code{bias} is False, the calculations are
corrected for bias and the value computed is the adjusted
Fisher-Pearson standardized moment coefficient, i.e.

\eqn{ G_1 = \frac{k_3}{k_2^{3/2}} = \frac{\sqrt{N(N-1)}}{N-2}\frac{m_3}{m_2^{3/2}}}
}
}
\examples{
df = pl$DataFrame(list(a = c(1:3, 2:1)))
df$select(pl$col("a")$skew())
}
\references{
https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.skew.html?highlight=skew#scipy.stats.skew
}
\keyword{Expr}
