% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_tree.R
\name{predict.policy_tree}
\alias{predict.policy_tree}
\title{Predict method for policy_tree}
\usage{
\method{predict}{policy_tree}(object, newdata, ...)
}
\arguments{
\item{object}{policy_tree object}

\item{newdata}{A data frame with features}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A vector of predictions. Each element is an integer from 1 to d where d is
the number of columns in the reward matrix.
}
\description{
Predict values based on fitted policy_tree object.
}
\examples{
\donttest{
n <- 50
p <- 10
d <- 3
features <- matrix(rnorm(n * p), n, p)
rewards <- matrix(rnorm(n * d), n, d)
tree <- policy_tree(features, rewards, depth = 2)
print(tree)
predict(tree, features)
}
}
