% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sessions.R
\name{Sessions}
\alias{Sessions}
\title{R6 class to track polished sessions}
\description{
An instance of this class handles the 'polished' user sessions for each 'shiny'
app using 'polished'.  The 'shiny' developer should not need to interact with
this class directly.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-config}{\code{Sessions$config()}}
\item \href{#method-sign_in_social}{\code{Sessions$sign_in_social()}}
\item \href{#method-get_invite_by_email}{\code{Sessions$get_invite_by_email()}}
\item \href{#method-find}{\code{Sessions$find()}}
\item \href{#method-sign_in_email}{\code{Sessions$sign_in_email()}}
\item \href{#method-register_email}{\code{Sessions$register_email()}}
\item \href{#method-refresh_email_verification}{\code{Sessions$refresh_email_verification()}}
\item \href{#method-set_signed_in_as}{\code{Sessions$set_signed_in_as()}}
\item \href{#method-get_signed_in_as_user}{\code{Sessions$get_signed_in_as_user()}}
\item \href{#method-set_inactive}{\code{Sessions$set_inactive()}}
\item \href{#method-sign_out}{\code{Sessions$sign_out()}}
\item \href{#method-get_admin_mode}{\code{Sessions$get_admin_mode()}}
\item \href{#method-clone}{\code{Sessions$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-config"></a>}}
\if{latex}{\out{\hypertarget{method-config}{}}}
\subsection{Method \code{config()}}{
polished Sessions configuration function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$config(
  firebase_config = NULL,
  admin_mode = FALSE,
  is_invite_required = TRUE,
  sign_in_providers = "email",
  is_email_verification_required = TRUE,
  is_auth_required = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Details}{
This function is called via \code{global_sessions_config()} in global.R
of all Shiny apps using polished.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sign_in_social"></a>}}
\if{latex}{\out{\hypertarget{method-sign_in_social}{}}}
\subsection{Method \code{sign_in_social()}}{
verify the users Firebase JWT and store the session
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$sign_in_social(firebase_token, hashed_cookie)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{firebase_token}}{the Firebase JWT.  This JWT is created client side
(in JavaScript) via \code{firebase.auth()}.}

\item{\code{hashed_cookie}}{the hashed polished cookie.  Used for tracking the user
session.  This cookie is inserted into the "polished.sessions" table if the
JWT is valid.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL if sign in fails. If sign in is successful, a list containing the following:
\itemize{
\item email
\item email_verified
\item is_admin
\item user_uid
\item hashed_cookie
\item session_uid
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_invite_by_email"></a>}}
\if{latex}{\out{\hypertarget{method-get_invite_by_email}{}}}
\subsection{Method \code{get_invite_by_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$get_invite_by_email(email)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-find"></a>}}
\if{latex}{\out{\hypertarget{method-find}{}}}
\subsection{Method \code{find()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$find(hashed_cookie, page)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sign_in_email"></a>}}
\if{latex}{\out{\hypertarget{method-sign_in_email}{}}}
\subsection{Method \code{sign_in_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$sign_in_email(email, password, hashed_cookie)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-register_email"></a>}}
\if{latex}{\out{\hypertarget{method-register_email}{}}}
\subsection{Method \code{register_email()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$register_email(email, password, hashed_cookie)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-refresh_email_verification"></a>}}
\if{latex}{\out{\hypertarget{method-refresh_email_verification}{}}}
\subsection{Method \code{refresh_email_verification()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$refresh_email_verification(session_uid, firebase_token)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_signed_in_as"></a>}}
\if{latex}{\out{\hypertarget{method-set_signed_in_as}{}}}
\subsection{Method \code{set_signed_in_as()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$set_signed_in_as(session_uid, signed_in_as, user_uid = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_signed_in_as_user"></a>}}
\if{latex}{\out{\hypertarget{method-get_signed_in_as_user}{}}}
\subsection{Method \code{get_signed_in_as_user()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$get_signed_in_as_user(user_uid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_inactive"></a>}}
\if{latex}{\out{\hypertarget{method-set_inactive}{}}}
\subsection{Method \code{set_inactive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$set_inactive(session_uid, user_uid)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sign_out"></a>}}
\if{latex}{\out{\hypertarget{method-sign_out}{}}}
\subsection{Method \code{sign_out()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$sign_out(hashed_cookie)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_admin_mode"></a>}}
\if{latex}{\out{\hypertarget{method-get_admin_mode}{}}}
\subsection{Method \code{get_admin_mode()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$get_admin_mode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Sessions$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
