% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy_app.R
\name{deploy_app}
\alias{deploy_app}
\title{Deploy a Shiny app to Polished Hosting}
\usage{
deploy_app(
  app_name,
  app_dir = ".",
  api_key = getOption("polished")$api_key,
  launch_browser = TRUE,
  region = "us-east1",
  ram_gb = 2,
  r_ver = NULL,
  tlmgr = character(0),
  golem_package_name = NULL,
  cache = TRUE
)
}
\arguments{
\item{app_name}{You Shiny app's name.}

\item{app_dir}{The path to the directory containing your Shiny app.}

\item{api_key}{Your polished.tech API key.  Defaults to \code{getOption("polished")$api_key}.}

\item{launch_browser}{Whether or not to open your default browser to your newly deployed app
after it is successfully deployed.  \code{TRUE} by default.}

\item{region}{the region to deploy the app to on Google Cloud Platform. See
\url{https://cloud.google.com/run/docs/locations} for all available regions
on Google Cloud Platform. Currently, database connections are only supported for
"us-east1". See \url{https://polished.tech/docs/06-database-connections} for details.}

\item{ram_gb}{the amount of memory to allocate to your Shiny app server. Valid values are
2, 4, or 8.}

\item{r_ver}{Character string of R version.  If kept as \code{NULL}, the default, then
\code{deploy_app()} will detect the R version you are currently running.  The R version must be a version
supported by an r-ver Docker image.  You can see all the r-ver Docker image versions
of R here \url{https://github.com/rocker-org/rocker-versioned2/tree/master/dockerfiles} and here
\url{https://github.com/rocker-org/rocker-versioned/tree/master/r-ver}.}

\item{tlmgr}{a character vector of TeX Live packages to install.  This is only used if your Shiny
app generates pdf documents.  Defaults to \code{character(0)} for no TeX Live installation.  Set to
\code{TRUE} for a minimal TeX Live installation, and pass a character vector of your TeX Live package
dependencies to have all your TeX Live packages installed at build time.}

\item{golem_package_name}{if Shiny app was created as a package with the
golem package, provide the name of the Shiny app package as a character string.
Defaults to \code{NULL}.  Keep as \code{NULL} for non golem Shiny apps.}

\item{cache}{boolean - whether or not to cache the Docker image.}
}
\description{
Deploy a Shiny app to Polished Hosting
}
\examples{

\dontrun{
deploy_app(
  app_name = "polished_example_01",
  app_dir = system.file("examples/polished_example_01", package = "polished"),
  api_key = "<your polished.tech API key>"
)
}


}
