% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firebase_init.R
\name{firebase_init}
\alias{firebase_init}
\title{Initialize Firebase}
\usage{
firebase_init(firebase_config)
}
\arguments{
\item{firebase_config}{named \code{list} of firebase configuration values.
Required values are:
\itemize{
\item \code{apiKey}
\item \code{authDomain}
\item \code{projectId}
}}
}
\value{
a character string of JavaScript code to initialize Firebase
}
\description{
Executes a few lines of JavaScript to initialize Firebase. This function should be
called in your Shiny UI immediately after \code{\link{firebase_dependencies}}.
}
\examples{


\dontrun{
my_config <- list(
  apiKey = "your Firebase API key",
  authDomain = "your Firebase auth domain",
  projectId = "your Firebase Project ID"
)

firebase_init(my_config)
}
}
