% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/politely.R
\name{politely}
\alias{politely}
\title{Give your web-scraping function good manners polite}
\usage{
politely(
  fun,
  user_agent = paste0("polite ", getOption("HTTPUserAgent"), " bot"),
  robots = TRUE,
  force = FALSE,
  delay = 5,
  verbose = FALSE,
  cache = memoise::cache_memory()
)
}
\arguments{
\item{fun}{function to be turned "polite". Must contain an argument named \code{url}, which contains url to be queried.}

\item{user_agent}{optional, user agent string to be used. Defaults to \code{paste("polite", getOption("HTTPUserAgent"), "bot")}}

\item{robots}{optional, should robots.txt be consulted for permissions. Default is TRUE}

\item{force}{whether or not tp force fresh download of robots.txt}

\item{delay}{minimum delay in seconds, not less than 1. Default is 5.}

\item{verbose}{output more information about querying process}

\item{cache}{memoise cache function for storing results. Default \code{memoise::cache_memory()}}
}
\value{
polite function
}
\description{
Give your web-scraping function good manners polite
}
\examples{

polite_GET <- politely(httr::GET)
}
