% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_def.R
\name{dynamic_policy}
\alias{dynamic_policy}
\title{Define Dynamic Policy}
\usage{
dynamic_policy(fun)
}
\arguments{
\item{fun}{Function with arguments associated with variables a given history
object, see example. The function must return a vector of character strings.}
}
\value{
function with arguments \code{history}. Specifically,
\code{history} is a history object, see \link{history}. When evaluated, the
function returns a \link{data.table} with keys \code{id} and \code{stage} and
action variable \code{d}.
}
\description{
\code{dynamic_policy} defines a dynamic policy given by a
user-specifed function.
}
\examples{
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d <- sim_two_stage(5e2, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# getting the state/Markov-type history object for stage 2:
his <- get_history(pd, stage = 2)

# avaible variable names:
get_history_names(pd)
colnames(his$H)

# applying the dynamic policy at stage 2:
head(dynamic_policy(fun = function(C) C>1)(his))

# getting the full history object for stage 2:
his <- get_history(pd, stage = 2, full_history = TRUE)

# avaible variable names:
get_history_names(pd, stage = 2)
colnames(his$H)

# applying the dynamic policy at stage 2:
head(dynamic_policy(fun = function(C_1, C_2) (C_1>1) & (C_2>1))(his))
}
