% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_learn.R
\name{get_policy_object}
\alias{get_policy_object}
\title{Get Policy Object}
\usage{
get_policy_object(object)
}
\arguments{
\item{object}{Object of class \link{policy_eval}.}
}
\value{
Object of class \link{policy_object}.
}
\description{
Extract the fitted policy object.
}
\examples{
library("polle")
### Single stage:
source(system.file("sim", "single_stage.R", package="polle"))
d1 <- sim_single_stage(5e2, seed=1)
pd1 <- policy_data(d1, action="A", covariates=list("Z", "B", "L"), utility="U")
pd1


# evaluating the policy:
pe1 <- policy_eval(policy_data = pd1,
                   policy_learn = policy_learn(type = "rqvl",
                                               qv_models = q_glm(~.)),
                   g_models = g_glm(),
                   q_models = q_glm())

# extracting the policy object:
get_policy_object(pe1)
}
