% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptl.R
\name{control_ptl}
\alias{control_ptl}
\title{Control arguments for Policy Tree Learning}
\usage{
control_ptl(
  policy_vars = NULL,
  hybrid = FALSE,
  depth = 2,
  search.depth = 2,
  split.step = 1,
  min.node.size = 1
)
}
\arguments{
\item{policy_vars}{Character vector/string or list of character
vectors/strings. Variable names used to construct the V-restricted policy tree.
The names must be a subset of the history names, see get_history_names().
Not passed to \code{policy_tree()}.}

\item{hybrid}{If \code{TRUE}, \code{\link[policytree:hybrid_policy_tree]{policytree::hybrid_policy_tree()}} is used to
fit a policy tree. Not passed to \code{policy_tree()}.}

\item{depth}{Integer or integer vector. The depth of the fitted policy
tree for each stage.}

\item{search.depth}{(only used if \code{hybrid = TRUE}) Integer or integer
vector. Depth to look ahead when splitting at each stage.}

\item{split.step}{Integer or integer vector. The number of possible splits
to consider when performing policy tree search at each stage.}

\item{min.node.size}{Integer or integer vector. The smallest terminal node
size permitted at each stage.}
}
\value{
list of (default) control arguments.
}
\description{
\code{control_ptl} sets the default control arguments
for doubly robust policy tree learning, \code{type = "ptl"}.
The arguments are passed directly to \code{\link[policytree:policy_tree]{policytree::policy_tree()}} (or
\code{\link[policytree:hybrid_policy_tree]{policytree::hybrid_policy_tree()}}) if not specified otherwise.
}
