% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_data_functions.R
\name{copy_policy_data}
\alias{copy_policy_data}
\title{Copy Policy Data Object}
\usage{
copy_policy_data(object)
}
\arguments{
\item{object}{Object of class \link{policy_data}.}
}
\value{
Object of class \link{policy_data}.
}
\description{
Objects of class \link{policy_data} contains elements of class \link{data.table}.
\code{data.table} provide functions that operate on objects by reference.
Thus, the \code{policy_data} object is not copied when modified by reference,
see examples. An explicit copy can be made by \code{copy_policy_data}. The
function is a wrapper of \code{\link[data.table:copy]{data.table::copy()}}.
}
\examples{
library("polle")
### Single stage case: Wide data
d1 <- sim_single_stage(5e2, seed=1)
head(d1, 5)
# constructing policy_data object:
pd1 <- policy_data(d1,
                   action="A",
                   covariates=c("Z", "B", "L"),
                   utility="U")
pd1

# True copy
pd2 <- copy_policy_data(pd1)
# manipulating the data.table by reference:
pd2$baseline_data[, id := id + 1]
head(pd2$baseline_data$id - pd1$baseline_data$id)

# False copy
pd2 <- pd1
# manipulating the data.table by reference:
pd2$baseline_data[, id := id + 1]
head(pd2$baseline_data$id - pd1$baseline_data$id)
}
