% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DesignEffectAndMOE.R
\name{moedeff_calc}
\alias{moedeff_calc}
\title{Calculate the margin of error (including design effect) of a sample}
\usage{
moedeff_calc(pct, deff, n, zscore = 1.96)
}
\arguments{
\item{pct}{a proportion}

\item{deff}{a design effect}

\item{n}{the sample size}

\item{zscore}{defaults to 1.96, consistent with a 95\% confidence interval.}
}
\value{
A percentage
}
\description{
\code{moedeff_calc} returns a single number. It is designed for use in the moe family of functions.
}
\details{
This function returns the margin of error including design effect of a given sample of weighted data using the formula
 sqrt(deff)*zscore*sqrt((pct*(1-pct))/(n-1))*100
}
\examples{
moedeff_calc(pct = 0.515, deff = 1.6, n = 214)
}
