% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cqp}
\alias{cqp}
\alias{is.cqp}
\alias{as.cqp}
\title{Tools for CQP queries.}
\usage{
is.cqp(query)

as.cqp(query, normalise.case = FALSE, collapse = FALSE)
}
\arguments{
\item{query}{character vector with at least one query}

\item{normalise.case}{logical}

\item{collapse}{logical, whether to collapse the queries into one}
}
\value{
\code{is.cqp} returns a logical value, \code{as.cqp} a character vector
}
\description{
Test whether a character string is a CQP query, or turn a character
vector into CQP queries.
}
\details{
The \code{is.cqp} function guesses whether \code{query} is a CQP query 
and returns the respective logical value (TRUE/FALSE).

The \code{as.cqp} function takes a character vector as input and converts it
to a CQP query by putting the individual strings in quotation marks.
}
\examples{
is.cqp("migration") # will return FALSE
is.cqp('"migration"') # will return TRUE
is.cqp('[pos = "ADJA"] "migration"') # will return TRUE

as.cqp("migration")
as.cqp(c("migration", "diversity"))
as.cqp(c("migration", "diversity"), collapse = TRUE)
as.cqp("migration", normalise.case = TRUE)
}
\references{
CQP Query Language Tutorial (\url{http://cwb.sourceforge.net/files/CQP_Tutorial.pdf})
}
