% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mail.R
\docType{methods}
\name{mail}
\alias{mail}
\alias{mail-method}
\alias{mail,textstat-method}
\alias{mail,data.frame-method}
\alias{mail,kwic-method}
\title{Mail result.}
\usage{
mail(.Object, ...)

\S4method{mail}{textstat}(.Object, to = getOption("polmineR.email"),
  rows = 1L:min(250L, nrow(.Object)))

\S4method{mail}{data.frame}(.Object, to = getOption("polmineR.email"),
  filename = tempfile(fileext = ".xlsx"), rows = 1L:min(250L,
  nrow(.Object)))

\S4method{mail}{kwic}(.Object, to = getOption("polmineR.email"),
  rows = 1L:min(250L, nrow(.Object)))
}
\arguments{
\item{.Object}{The object to deliver.}

\item{...}{Further parameters.}

\item{to}{The recipient of the mail message.}

\item{rows}{The number of rows of the table (if NULL, the whole table will be sent).}

\item{filename}{The filename of the (temporary) xlsx-file that is generated.}
}
\description{
Send out a mail with the statistics of an object attached as an xlsx-file.
}
