% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context_class.R, R/count_method.R,
%   R/enrich_method.R, R/trim_method.R
\docType{class}
\name{context-class}
\alias{context-class}
\alias{context_class}
\alias{show,context-method}
\alias{[,context-method}
\alias{[,context,ANY,ANY,ANY-method}
\alias{[[,context-method}
\alias{summary,context-method}
\alias{head,context-method}
\alias{as.DataTables,context-method}
\alias{sample,context-method}
\alias{count,context-method}
\alias{enrich,context-method}
\alias{trim,context-method}
\title{Context class.}
\usage{
\S4method{sample}{context}(x, size)

\S4method{count}{context}(.Object)

\S4method{enrich}{context}(.Object, sAttribute = NULL, pAttribute = NULL,
  id2str = FALSE, verbose = TRUE)

\S4method{trim}{context}(object, sAttribute = NULL, verbose = TRUE,
  progress = TRUE)
}
\arguments{
\item{x}{a context object}

\item{size}{integer indicating sample size}

\item{.Object}{object}

\item{sAttribute}{s-attribute(s) to add to data.table in cpos-slot}

\item{pAttribute}{p-attribute(s) to add to data.table in cpos-slot}

\item{id2str}{logical, whether to convert integer ids to expressive strings}

\item{verbose}{logical, whether to be talkative}

\item{object}{a context object}

\item{progress}{logical, whether to show progress bar}
}
\description{
Class to organize information of context analysis.
}
\details{
Objects of the class \code{context} include a \code{data.table} in the
slot \code{cpos}. The \code{data.table} will at least include the columns "hit_no",
"cpos" and "position".

The \code{enrich}-method can be used to add additional information to the \code{data.table}
in the "cpos"-slot of a \code{context}-object.
}
\section{Slots}{

\describe{
\item{\code{query}}{Object of class \code{"character"}, the query/node examined}

\item{\code{count}}{Object of class \code{"numeric"} number of hits}

\item{\code{partition}}{Object of class \code{"partition"}, the partition the context object is based on}

\item{\code{partitionSize}}{Object of class \code{"numeric"} the size of the partition}

\item{\code{left}}{Object of class \code{"numeric"} number of tokens to the left}

\item{\code{right}}{Object of class \code{"numeric"} number of tokens to the right}

\item{\code{size}}{Object of class \code{"numeric"} number of tokens in the right and left context}

\item{\code{sAttribute}}{Object of class \code{"character"} s-attribute}

\item{\code{pAttribute}}{Object of class \code{"character"} p-attribute of the query}

\item{\code{corpus}}{Object of class \code{"character"} the CWB corpus used}

\item{\code{stat}}{Object of class \code{"data.table"} statistics of the analysis}

\item{\code{encoding}}{Object of class \code{"character"} encoding of the corpus}

\item{\code{cpos}}{Object of class \code{"list"} corpus positions of the hits}

\item{\code{method}}{Object of class \code{"character"} statistical test used}

\item{\code{call}}{Object of class \code{"character"} call that generated the object}
}}

