% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry.R
\name{resetRegistry}
\alias{resetRegistry}
\title{Reload using new CORPUS_REGISTRY.}
\usage{
resetRegistry(registryDir = getOption("polmineR.defaultRegistry"),
  verbose = TRUE)
}
\arguments{
\item{registryDir}{path to the registry directory to be used}

\item{verbose}{logical, whether to be verbose}
}
\value{
the registry directory used before resetting CORPUS_REGISTRY
}
\description{
A utility function to reset the environment variable CORPUS_REGISTRY. That may
be necessary if you want use a CWB corpus that is not stored in the usual
place. In particular, resetting the environment variable is required if you
want to use a corpus delivered in a R package,
}
\details{
Resetting the CORPUS_REGISTRY environment variable is achieved by unloading 
and reloading the C library 'rcqp' that is the backend for the rcqp package. 
It may not be the most artful way to do things, but it works.

To get the path to a package that contains a CWB corpus, use
\code{system.file}.
}
\examples{
\donttest{
sampleCorpusPkgDir <- system.file(package="polmineR.sampleCorpus")
sampleCorpusRegistryDir <- file.path(sampleCorpusPkgDir, "extdata", "cwb", "registry")
oldRegistryDir <- resetRegistry(sampleCorpusRegistryDir)
sampleCorpusPartition <- partition("PLPRBTTXT", text_speaker = "Volker Kauder")
resetRegistry(oldRegistryDir)
}
}
