% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_method.R
\docType{methods}
\name{count}
\alias{count}
\alias{count-method}
\alias{count,partition-method}
\alias{count,partitionBundle-method}
\alias{count,character-method}
\alias{count,vector-method}
\alias{count,Corpus-method}
\title{Get counts.}
\usage{
count(.Object, ...)

\S4method{count}{partition}(.Object, query = NULL, cqp = is.cqp,
  breakdown = FALSE, decode = TRUE,
  pAttribute = getOption("polmineR.pAttribute"),
  mc = getOption("polmineR.cores"), verbose = TRUE, progress = FALSE)

\S4method{count}{partitionBundle}(.Object, query, cqp = FALSE,
  pAttribute = NULL, freq = FALSE, total = TRUE, mc = FALSE,
  progress = TRUE, verbose = FALSE)

\S4method{count}{character}(.Object, query = NULL, cqp = is.cqp,
  pAttribute = getOption("polmineR.pAttribute"), breakdown = FALSE,
  sort = FALSE, decode = TRUE, verbose = TRUE)

\S4method{count}{vector}(.Object, corpus, pAttribute)

\S4method{count}{Corpus}(.Object, query = NULL, pAttribute)
}
\arguments{
\item{.Object}{a \code{"partition"} or \code{"partitionBundle"} object, or a
character vector (length 1) providing the name of a corpus}

\item{...}{further parameters}

\item{query}{a character vector (one or multiple terms to be looked up), CQP
syntax can be used.}

\item{cqp}{either logical (TRUE if query is a CQP query), or a
function to check whether query is a CQP query or not (defaults to is.query
auxiliary function)}

\item{breakdown}{logical, whether to count occurrences for different matches for a query}

\item{decode}{logical, whether to add rownames (only if query is NULL)}

\item{pAttribute}{the p-attribute(s) to use}

\item{mc}{logical, whether to use multicore (defaults to FALSE)}

\item{verbose}{logical, whether to be verbose}

\item{progress}{logical, whether to show progress}

\item{freq}{logical, if FALSE, counts will be reported, if TRUE, frequencies}

\item{total}{defaults to FALSE, if TRUE, the added value of counts (column:
TOTAL) will be amended to the data.table that is returned}

\item{sort}{logical, whether to sort stat}

\item{corpus}{name of CWB corpus}
}
\value{
a \code{"data.table"}
}
\description{
Count all tokens, or number of occurrences of a query (CQP syntax may be
used), or matches for the query.
}
\details{
If .Object is a \code{partitonBundle}, the data.table returned will have the
queries in the columns, and as many rows as there are in the partitionBundle.

If .Object is a character vector (length 1) and query is NULL, the count is
performed for the whole partition. If \code{breakdown} is \code{TRUE} and one
query is supplied, the function returns a frequency breakdown of the results
of the query. If several queries are supplied, frequencies for the individual
queries are retrieved.
}
\examples{
  use("polmineR")
  debates <- partition("GERMAPARLMINI", date = ".*", regex=TRUE)
  count(debates, query = "Arbeit") # get frequencies for one token
  count(debates, c("Arbeit", "Freizeit", "Zukunft")) # get frequencies for multiple tokens
  
  count("GERMAPARLMINI", query = c("Migration", "Integration"), pAttribute = "word")

  debates <- partitionBundle(
    "GERMAPARLMINI", sAttribute = "date", values = NULL,
    regex = TRUE, mc = FALSE, verbose = FALSE
  )
  y <- count(debates, query = "Arbeit", pAttribute = "word")
  y <- count(debates, query = c("Arbeit", "Migration", "Zukunft"), pAttribute = "word")
  
  count("GERMAPARLMINI", '"Integration.*"', breakdown = TRUE)

  P <- partition("GERMAPARLMINI", date = "2009-11-11")
  count(P, '"Integration.*"', breakdown = TRUE)
}
\references{
Baker, Paul (2006): \emph{Using Corpora in Discourse Analysis}. London: continuum, p. 47-69 (ch. 3).
}
\seealso{
For a metadata-based breakdown of counts
(i.e. tabulation by s-attributes), see \code{"dispersion"}.

count
}
