% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight_method.R
\docType{methods}
\name{highlight}
\alias{highlight}
\alias{highlight,character-method}
\alias{highlight,html-method}
\alias{highlight,kwic-method}
\title{Highlight tokens.}
\usage{
highlight(.Object, ...)

\S4method{highlight}{character}(.Object, highlight = list())

\S4method{highlight}{html}(.Object, highlight = list())

\S4method{highlight}{kwic}(.Object, highlight = list(), regex = FALSE,
  perl = TRUE, verbose = TRUE)
}
\arguments{
\item{.Object}{a \code{html} or \code{character} object with html, or a 
\code{kwic} object}

\item{...}{further parameters (unused)}

\item{highlight}{a \code{"list"} of character or integer vectors, the names 
need to provide the colors, the values of the vector the term to be matched
or a corpus position}

\item{regex}{logical, whether character vectors give regular expressions}

\item{perl}{logical, whether to use perl-style regular expressions for
highlighting when regex is TRUE}

\item{verbose}{logical, whether to output verbose messages}
}
\description{
Highlight tokens based on exact match, a regular expression or corpus
position in kwic output or html document.
}
\examples{
use("polmineR")
P <- partition("REUTERS", places = "argentina")
H <- html(P)
Y <- highlight(H, list(lightgreen = "higher"))
if (interactive()) htmltools::html_print(Y)

# highlight matches for a CQP query
H2 <- highlight(
  H,
  highlight = list(yellow = cpos(hits(P, query = '"prod.*"', cqp = TRUE)))
)

# the method can be used in pipe
if (require("magrittr")){
  P \%>\% html() \%>\% highlight(list(lightgreen = "1986")) -> H
  P \%>\% html() \%>\% highlight(list(lightgreen = c("1986", "higher"))) -> H
  P \%>\% html() \%>\% highlight(list(lightgreen = 4020:4023)) -> H
}

# use highlight for kwic output
K <- kwic("REUTERS", query = "barrel")
K2 <- highlight(K, highlight = list(yellow = c("oil", "price")))
if (interactive()) K2
}
