% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms_method.R
\docType{methods}
\name{terms}
\alias{terms}
\alias{terms,partition-method}
\alias{terms,character-method}
\title{Get Terms Occurring in Partition or Corpus.}
\usage{
\S4method{terms}{partition}(x, pAttribute, regex = NULL)

\S4method{terms}{character}(x, pAttribute, regex = NULL, robust = FALSE)
}
\arguments{
\item{x}{an atomic \code{character} vector with a corpus id or \code{partition} object}

\item{pAttribute}{the p-attribute to be analyzed}

\item{regex}{regular expression(s) to filter results}

\item{robust}{logical, whether to check for potential failures}
}
\description{
Get Terms Occurring in Partition or Corpus.
}
\examples{
use("polmineR")
session <- partition("GERMAPARLMINI", date = "2009-10-27")
words <- terms(session, "word")
terms(session, pAttribute = "word", regex = "^Arbeit.*")
terms(session, pAttribute = "word", regex = c("Arbeit.*", ".*arbeit"))

terms("GERMAPARLMINI", pAttribute = "word")
terms("GERMAPARLMINI", pAttribute = "word", regex = "^Arbeit.*")
}
