% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooccurrences.R
\docType{methods}
\name{cooccurrences}
\alias{cooccurrences}
\alias{cooccurrences,character-method}
\alias{cooccurrences,partition-method}
\alias{cooccurrences,context-method}
\alias{cooccurrences,partition_bundle-method}
\title{Get cooccurrence statistics.}
\usage{
cooccurrences(.Object, ...)

\S4method{cooccurrences}{character}(.Object, query, cqp = is.cqp,
  p_attribute = getOption("polmineR.p_attribute"), s_attribute = NULL,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  stoplist = NULL, positivelist = NULL, regex = FALSE, keep = NULL,
  cpos = NULL, method = "ll", mc = getOption("polmineR.mc"),
  verbose = FALSE, progress = FALSE, ...)

\S4method{cooccurrences}{partition}(.Object, query, cqp = is.cqp,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  p_attribute = getOption("polmineR.p_attribute"), s_attribute = NULL,
  stoplist = NULL, positivelist = NULL, keep = NULL, method = "ll",
  mc = FALSE, progress = TRUE, verbose = FALSE, ...)

\S4method{cooccurrences}{context}(.Object, method = "ll", verbose = FALSE)

\S4method{cooccurrences}{partition_bundle}(.Object, query,
  mc = getOption("polmineR.mc"), ...)
}
\arguments{
\item{.Object}{a partition object, or a character vector with a CWB corpus}

\item{...}{further parameters that will be passed into bigmatrix (applies only of big=TRUE)}

\item{query}{query, may by a character vector to match a token, or a CQP query}

\item{cqp}{defaults to \code{is.cqp}-function, or provide TRUE/FALSE, relevant only if query is not NULL}

\item{p_attribute}{the p-attribute of the tokens/the query}

\item{s_attribute}{if provided, it will be checked that cpos do not extend beyond
the region defined by the s-attribute}

\item{left}{no of tokens and to the left of the node word}

\item{right}{no of tokens to the right of the node word}

\item{stoplist}{exclude a query hit from analysis if stopword(s) is/are in
context (relevant only if query is nut NULL)}

\item{positivelist}{character vector or numeric vector: include a query hit
only if token in positivelist is present. If positivelist is a character
vector, it is assumed to provide regex expressions (incredibly long if the
list is long) (relevant only if query is nut NULL)}

\item{regex}{logical, whether stoplist/positivelist are dealt with as regular expressions}

\item{keep}{list with tokens to keep}

\item{cpos}{integer vector with corpus positions, defaults to NULL - then the corpus positions for the whole corpus will be used}

\item{method}{statistical test to use (defaults to "ll")}

\item{mc}{whether to use multicore}

\item{verbose}{logical, whether to be verbose}

\item{progress}{logical, whether to be verbose}
}
\value{
a cooccurrences-class object
}
\description{
Get cooccurrence statistics.
}
\examples{
use("polmineR")
merkel <- partition("GERMAPARLMINI", interjection = "speech", speaker = ".*Merkel", regex = TRUE)
merkel <- enrich(merkel, p_attribute = "word")
cooc <- cooccurrences(merkel, query = "Deutschland")
}
\references{
Baker, Paul (2006): \emph{Using Corpora in Discourse Analysis}. London: continuum, p. 95-120 (ch. 5).

Manning, Christopher D.; Schuetze, Hinrich (1999): \emph{Foundations of Statistical Natural Language
Processing}. MIT Press: Cambridge, Mass., pp. 151-189 (ch. 5).
}
\author{
Andreas Blaette
}
