% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_attributes.R
\docType{methods}
\name{p_attributes}
\alias{p_attributes}
\alias{p_attributes,character-method}
\title{Get p-attributes.}
\usage{
p_attributes(.Object, ...)

\S4method{p_attributes}{character}(.Object, p_attribute = NULL, ...)
}
\arguments{
\item{.Object}{a character vector (length 1) or partition object}

\item{...}{further arguments}

\item{p_attribute}{p-attribute to decode}
}
\description{
In a CWB corpus, every token has positional attributes. While s-attributes
cover a range of tokens, every single token in the token stream of a corpus
will have a set of positional attributes (such as part-of-speech, or lemma).
The available p-attributes are returned by the p_attributes-method.
}
\examples{
use("polmineR")
p_attributes("GERMAPARLMINI")
}
\references{
Stefan Evert & The OCWB Development Team, CQP Query Language Tutorial, http://cwb.sourceforge.net/files/CQP_Tutorial.pdf.
}
