% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\docType{methods}
\name{size}
\alias{size}
\alias{size,character-method}
\alias{size,partition-method}
\alias{size,DocumentTermMatrix-method}
\title{Get Number of Tokens.}
\usage{
size(x, ...)

\S4method{size}{character}(x, s_attribute = NULL, verbose = TRUE, ...)

\S4method{size}{partition}(x, s_attribute = NULL, ...)

\S4method{size}{DocumentTermMatrix}(x)
}
\arguments{
\item{x}{object to get size(s) for}

\item{...}{further arguments}

\item{s_attribute}{character vector with s-attributes (one or more)}

\item{verbose}{logical, whether to print messages}
}
\value{
an integer vector if s_attribute is NULL, a \code{data.table} otherweise
}
\description{
The method will get the number of tokens in a corpus or partition,
or the dispersion across one or more s-attributes.
}
\details{
One or more s-attributes can be provided to get the dispersion of
tokens across one or more dimensions. Two or more s-attributes
can lead to reasonable results only if the corpus XML is flat.
}
\examples{
use("polmineR")
size("GERMAPARLMINI")
size("GERMAPARLMINI", s_attribute = "date")
size("GERMAPARLMINI", s_attribute = c("date", "party"))

P <- partition("GERMAPARLMINI", date = "2009-11-11")
size(P, s_attribute = "speaker")
size(P, s_attribute = "party")
size(P, s_attribute = c("speaker", "party"))
}
\seealso{
See \code{\link{dispersion}}-method for counts of hits. The \code{\link{hits}}
method calls the \code{size}-method to get sizes of subcorpora.
}
