% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\docType{methods}
\name{html}
\alias{html}
\alias{show,html-method}
\alias{html,character-method}
\alias{html,partition-method}
\alias{html,subcorpus-method}
\alias{html,partition_bundle-method}
\alias{html,kwic-method}
\alias{html,remote_subcorpus-method}
\title{Generate html from object.}
\usage{
html(object, ...)

\S4method{html}{character}(object, corpus, height = NULL)

\S4method{html}{partition}(
  object,
  meta = NULL,
  cpos = TRUE,
  verbose = FALSE,
  cutoff = NULL,
  charoffset = FALSE,
  beautify = TRUE,
  height = NULL,
  ...
)

\S4method{html}{subcorpus}(
  object,
  meta = NULL,
  cpos = TRUE,
  verbose = FALSE,
  cutoff = NULL,
  charoffset = FALSE,
  beautify = FALSE,
  height = NULL,
  ...
)

\S4method{html}{partition_bundle}(
  object,
  charoffset = FALSE,
  beautify = TRUE,
  height = NULL,
  progress = TRUE,
  ...
)

\S4method{html}{kwic}(object, i, s_attribute = NULL, type = NULL, verbose = FALSE)

\S4method{html}{remote_subcorpus}(object, ...)
}
\arguments{
\item{object}{The object the fulltext output will be based on.}

\item{...}{Further parameters that are passed into \code{as.markdown}.}

\item{corpus}{The ID of the corpus, a length-one \code{character} vector.}

\item{height}{A \code{character} vector that will be inserted into the html
as an optional height of a scroll box.}

\item{meta}{Metadata to include in  output, if \code{NULL} (default), the
s-attributes defining a partition will be used.}

\item{cpos}{Length-one \code{logical} value, if \code{TRUE} (default), all
tokens will be wrapped by elements with id attribute indicating corpus
positions.}

\item{verbose}{Length-one \code{logical} value, whether to output progress
messages.}

\item{cutoff}{An \code{integer} value, maximum number of tokens to decode
from token stream, passed into \code{as.markdown}.}

\item{charoffset}{Length-one \code{logical} value, if \code{TRUE}, character
offset positions are added to elements embracing tokens.}

\item{beautify}{Length-one \code{logical} value, if \code{TRUE}, whitespace
before interpunctuation will be removed.}

\item{progress}{Length-one \code{logical} value, whether to output progress#
bar.}

\item{i}{An \code{integer} value: If \code{object} is a \code{kwic}-object,
the index of the concordance for which the fulltext is to be generated.}

\item{s_attribute}{Structural attributes that will be used to define the partition
where the match occurred.}

\item{type}{The partition type.}
}
\value{
Returns an object of class \code{html} as used in the \code{htmltools} package. Methods
such as \code{htmltools::html_print} will be available. The encoding of the html
document will be UTF-8 on all systems (including Windows).
}
\description{
Prepare html document to see full text.
}
\details{
If param \code{charoffset} is \code{TRUE}, character offset positions will be
added to tags that embrace tokens. This may be useful, if exported html document
is annotated with a tool that stores annotations with character offset positions.
}
\examples{
use("polmineR")
P <- partition("REUTERS", places = "argentina")
H <- html(P)
if (interactive()) H # show full text in viewer pane

# html-method can be used in a pipe
H <- partition("REUTERS", places = "argentina") \%>\% html()
  
# use html-method to get full text where concordance occurrs
K <- kwic("REUTERS", query = "barrels")
H <- html(K, i = 1, s_attribute = "id")
H <- html(K, i = 2, s_attribute = "id")
for (i in 1L:length(K)) {
  H <- html(K, i = i, s_attribute = "id")
  if (interactive()){
    show(H)
    userinput <- readline("press 'q' to quit or any other key to continue")
    if (userinput == "q") break
  }
}
  
}
