% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{orient_and_merge_maps}
\alias{orient_and_merge_maps}
\title{Align and integrate maps}
\usage{
orient_and_merge_maps(maplist_P1, maplist_P2, parent_ID_1 = "P1",
  parent_ID_2 = "P2", connection_threshold = 2, LPmerge_interval = 4,
  single_LPmerge = FALSE, plot_graph = FALSE, ploidy = 4, log = NULL)
}
\arguments{
\item{maplist_P1, maplist_P2}{A list of length=ploidy, with data.frames containing markernames and position.}

\item{parent_ID_1, parent_ID_2}{Character string with parent IDs}

\item{connection_threshold}{The number of markers two homologues should have in common to have a significant connection}

\item{LPmerge_interval}{The \code{max.interval} value used for \code{\link[LPmerge]{LPmerge}}}

\item{single_LPmerge}{Logical, by default \code{FALSE}. If \code{TRUE} then only a single merge with max.interval = LPmerge_interval
will be run, otherwise all intervals up to LPmerge_interval will also be tested.}

\item{plot_graph}{Should the connection network be drawn?}

\item{ploidy}{The ploidy of the organism}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\description{
Align homologues to the same orientation and integrates maps using LPmerge
}
\examples{
data("maplist_P1_subset")
data("maplist_P2_subset")
\dontrun{
## Example temporarily suspended (April 2018): LPmerge CRAN issues
integrated_map_LG2<-orient_and_merge_maps(maplist_P1=maplist_P1_subset[["LG4"]],
                                            maplist_P2=maplist_P2_subset[["LG4"]],
                                            plot_graph = TRUE)
}
}
