% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{count_recombinations}
\alias{count_recombinations}
\title{Predict recombination breakpoints using IBD probabilities}
\usage{
count_recombinations(IBD_list, plausible_pairing_prob = 0.4)
}
\arguments{
\item{IBD_list}{List of IBD_probabilities as estimated using one of the various methods available (e.g. \code{\link{estimate_IBD}}), assuming bivalent pairing.}

\item{plausible_pairing_prob}{The minimum probability of a pairing configuration needed to analyse an individual's IBD data.
The default setting of 0.4 is rather low - but accommodates scenarios where e.g. two competing plausible pairing scenarios are possible.
In such situations, both pairing configurations (also termed "valencies") would be expected to have a probability close to 0.5. Both are then considered,
and the output contains the probability of both situations. These can then be used to generate a probabilistic recombination landscape. If a more definite 
set of predictions is required, simply increase \code{plausible_pairing_prob} to eliminate such uncertainty. These individuals will then be 
returned with a \code{NA} value.}
}
\value{
A nested list corresponding to each linkage group. Within each LG, a list with 3 items is returned, specifying the \code{plausible_pairing_prob}, the \code{map} and 
the predicted \code{recombinations} in each individual in the mapping population. Per individual, all valencies with a probability greater than
\code{plausible_pairing_prob} are returned, specifying both the \code{Valent_probability} and the best estimate of the cM position of the
\code{recombination_breakpoints} involving pairs of homologues A, B, C etc. (in the order parent 1, parent 2). 
If no recombinations are predicted, a \code{NA} value is given instead.
}
\description{
The function \code{count_recombinations} returns a list of all predicted recombination breakpoints. The output can be passed 
using the argument \code{recombination_data} to the function \code{\link{visualiseHaplo}}, where the predicted breakpoints overlay the haplotypes. 
Alternatively, a genome-wide visualisation of the recombination landscape both per linkage group and per individual can be generated using the function \code{\link{plotRecLS}}, 
which can be useful in identifying problematic areas of the linkage maps, or problematic individuals in the population.
}
\examples{
data("IBD_4x")
recom.ls <- count_recombinations(IBD_4x)
}
