% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_traj.R
\docType{methods}
\name{filter.traj}
\alias{filter.traj}
\alias{filter.traj,ANY-method}
\alias{filter.traj,missing-method}
\alias{filter.traj-pfilterd_pomp}
\alias{filter.traj,pfilterd_pomp-method}
\alias{filter.traj-pfilterList}
\alias{filter.traj,pfilterList-method}
\alias{filter.traj-pmcmcd_pomp}
\alias{filter.traj,pmcmcd_pomp-method}
\alias{filter.traj-pmcmcList}
\alias{filter.traj,pmcmcList-method}
\title{Filtering trajectories}
\usage{
\S4method{filter.traj}{pfilterd_pomp}(object, vars, ...)

\S4method{filter.traj}{pfilterList}(object, vars, ...)

\S4method{filter.traj}{pmcmcd_pomp}(object, vars, ...)

\S4method{filter.traj}{pmcmcList}(object, vars, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{...}{ignored}
}
\description{
Trajectories drawn from the smoothing distribution
}
\details{
The smoothing distribution is the distribution of
\deqn{X_t | Y_1=y^*_1, \dots, Y_T=y^*_T,}{Xt | Y1=y1*, \dots, YT=yT*,}
where \eqn{X_t}{Xt} is the latent state process, \eqn{Y_t}{Yt} is the observable process, \eqn{t} is time, and \eqn{T} is the time of the final observation.

In a particle filter, the trajectories of the individual particles are not independent of one another, since they share ancestry.
However, a randomly sampled particle trajectory \eqn{X_1,\dots,X_T} is a draw from the smoothing distribution.
Seting \code{filter.traj = TRUE} in \code{\link{pfilter}} causes one such trajectory to be sampled.
By running multiple independent \code{pfilter} operations, one can thus build up a picture of the smoothing distribution.

In particle MCMC (\code{\link{pmcmc}}), this operation is performed at each MCMC iteration.
Assuming the MCMC chain has converged, and after proper measures are taken to assure approximate independence of samples, \code{filter.traj} allows one to extract a sample from the smoothing distribution.
}
\seealso{
Other particle filter methods: \code{\link{bsmc2}},
  \code{\link{cond.logLik}}, \code{\link{eff.sample.size}},
  \code{\link{filter.mean}}, \code{\link{mif2}},
  \code{\link{pfilter}}, \code{\link{pmcmc}},
  \code{\link{pred.mean}}, \code{\link{pred.var}}
}
\concept{particle filter methods}
