% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_probes.R
\name{basic_probes}
\alias{basic_probes}
\alias{probe.mean}
\alias{probe.median}
\alias{probe.var}
\alias{probe.sd}
\alias{probe.period}
\alias{probe.quantile}
\alias{probe.acf}
\alias{probe.ccf}
\alias{probe.marginal}
\alias{probe.nlar}
\title{Useful probes for partially-observed Markov processes}
\usage{
probe.mean(var, trim = 0, transform = identity, na.rm = TRUE)

probe.median(var, na.rm = TRUE)

probe.var(var, transform = identity, na.rm = TRUE)

probe.sd(var, transform = identity, na.rm = TRUE)

probe.period(var, kernel.width, transform = identity)

probe.quantile(var, probs, ...)

probe.acf(var, lags, type = c("covariance", "correlation"),
  transform = identity)

probe.ccf(vars, lags, type = c("covariance", "correlation"),
  transform = identity)

probe.marginal(var, ref, order = 3, diff = 1, transform = identity)

probe.nlar(var, lags, powers, transform = identity)
}
\arguments{
\item{var, vars}{character; the name(s) of the observed variable(s).}

\item{trim}{the fraction of observations to be trimmed (see \code{\link{mean}}).}

\item{transform}{transformation to be applied to the data before the probe is computed.}

\item{na.rm}{if \code{TRUE}, remove all NA observations prior to computing the probe.}

\item{kernel.width}{width of modified Daniell smoothing kernel to be used
in power-spectrum computation: see \code{\link{kernel}}.}

\item{probs}{the quantile or quantiles to compute: see \code{\link{quantile}}.}

\item{...}{additional arguments passed to the underlying algorithms.}

\item{lags}{In \code{probe.ccf}, a vector of lags between time series.
Positive lags correspond to \code{x} advanced relative to \code{y};
negative lags, to the reverse.

In \code{probe.nlar}, a vector of lags present in the nonlinear
autoregressive model that will be fit to the actual and simulated data.
See Details, below, for a precise description.}

\item{type}{Compute autocorrelation or autocovariance?}

\item{ref}{empirical reference distribution.  Simulated data will be
regressed against the values of \code{ref}, sorted and, optionally,
differenced.  The resulting regression coefficients capture information
about the shape of the marginal distribution.  A good choice for \code{ref}
is the data itself.}

\item{order}{order of polynomial regression.}

\item{diff}{order of differencing to perform.}

\item{powers}{the powers of each term (corresponding to \code{lags}) in the
the nonlinear autoregressive model that will be fit to the actual and
simulated data.  See Details, below, for a precise description.}
}
\value{
A call to any one of these functions returns a probe function,
suitable for use in \code{\link{probe}} or \code{\link{probe_objfun}}.  That
is, the function returned by each of these takes a data array (such as
comes from a call to \code{\link{obs}}) as input and returns a single
numerical value.
}
\description{
Several simple and configurable probes are provided with in the package.
These can be used directly and as templates for custom probes.
}
\references{
B. E. Kendall, C. J. Briggs, W. M. Murdoch, P. Turchin, S. P.
Ellner, E. McCauley, R. M. Nisbet, S. N. Wood Why do populations cycle? A
synthesis of statistical and mechanistic modeling approaches, Ecology,
80:1789--1805, 1999.

S. N. Wood Statistical inference for noisy nonlinear ecological dynamic
systems, Nature, 466: 1102--1104, 2010.
}
\seealso{
Other summary statistics methods: \code{\link{abc}},
  \code{\link{probe.match}}, \code{\link{probe}},
  \code{\link{spect}}
}
\author{
Daniel C. Reuman, Aaron A. King
}
\concept{diagnostics}
\concept{summary statistics methods}
