% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_table.R
\name{covariate_table}
\alias{covariate_table}
\alias{covariate_table,missing-method}
\alias{covariate_table,ANY-method}
\alias{covariate_table,numeric-method}
\alias{covariate_table-numeric,covariate_table,numeric-method}
\alias{covariate_table,character-method}
\alias{covariate_table-character,covariate_table,character-method}
\title{Covariates}
\usage{
\S4method{covariate_table}{numeric}(..., order = c("linear", "constant"), times)

\S4method{covariate_table}{character}(..., order = c("linear", "constant"), times)
}
\arguments{
\item{\dots}{numeric vectors or data frames containing time-varying covariates.
It must be possible to bind these into a data frame.}

\item{order}{the order of interpolation to be used.
Options are \dQuote{linear} (the default) and \dQuote{constant}.
Setting \code{order="linear"} treats the covariates as piecewise linear functions of time;
\code{order="constant"} treats them as right-continuous piecewise constant functions.}

\item{times}{the times corresponding to the covariates.
This may be given as a vector of (non-decreasing, finite) numerical values.
Alternatively, one can specify by name which of the given variables is the time variable.}
}
\description{
Constructing lookup tables for time-varying covariates.
}
\details{
If the \sQuote{pomp} object contains covariates (specified via the \code{covar} argument), then interpolated values of the covariates will be available to each of the model components whenever it is called.
In particular, variables with names as they appear in the \code{covar} covariate table will be available to any C snippet.
When a basic component is defined using an \R function, that function will be called with an extra argument, \code{covars}, which will be a named numeric vector containing the interpolated values from the covariate table.

An exception to this rule is the prior (\code{rprior} and \code{dprior}):
covariate-dependent priors are not allowed.
Nor are parameter transformations permitted to depend upon covariates.
}
\seealso{
lookup

Other information on model implementation: 
\code{\link{Csnippet}},
\code{\link{accumulators}},
\code{\link{distributions}},
\code{\link{dmeasure_spec}},
\code{\link{dprocess_spec}},
\code{\link{parameter_trans}()},
\code{\link{pomp-package}},
\code{\link{prior_spec}},
\code{\link{rinit_spec}},
\code{\link{rmeasure_spec}},
\code{\link{rprocess_spec}},
\code{\link{skeleton_spec}},
\code{\link{transformations}},
\code{\link{userdata}}
}
\concept{information on model implementation}
