% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ricker.R
\docType{data}
\name{ricker}
\alias{ricker}
\title{Ricker model with Poisson observations.}
\usage{
ricker(r = exp(3.8), sigma = 0.3, phi = 10, c = 1, N_0 = 7)
}
\arguments{
\item{r}{intrinsic growth rate}

\item{sigma}{environmental process noise s.d.}

\item{phi}{sampling rate}

\item{c}{density dependence parameter}

\item{N_0}{initial condition}
}
\value{
A \sQuote{pomp} object containing the Ricker model and simulated data.
}
\description{
\code{ricker} is a \sQuote{pomp} object encoding a stochastic Ricker model
with Poisson measurement error.
}
\details{
The state process is \eqn{N_{t+1} = r N_{t} \exp(-c N_{t}+e_{t})}{N[t+1] =
r N[t] exp(-c N[t]+e[t])}, where the \eqn{e_t}{e[t]} are i.i.d. normal
random deviates with zero mean and variance \eqn{\sigma^2}{sigma^2}.  The
observed variables \eqn{y_t}{y[t]} are distributed as
\eqn{\mathrm{Poisson}(\phi N_t)}{Poisson(phi N[t])}.
}
\examples{
po <- ricker()
plot(po)
coef(po)
simulate(po) \%>\% plot()
}
\seealso{
Other pomp examples: 
\code{\link{blowflies}},
\code{\link{bsflu}},
\code{\link{dacca}()},
\code{\link{ebola}},
\code{\link{gompertz}()},
\code{\link{measles}},
\code{\link{ou2}()},
\code{\link{parus}},
\code{\link{pomp_examples}},
\code{\link{rw2}()},
\code{\link{sir_models}},
\code{\link{verhulst}()}
}
\concept{pomp examples}
\keyword{datasets}
\keyword{models}
