##' Estimation algorithms for POMP models.
##'
##' \pkg{pomp} currently implements the following algorithms for estimating model parameters:
##' \itemize{
##' \item \link[=mif2]{iterated filtering (IF2)}
##' \item \link[=pmcmc]{particle Markov chain Monte Carlo (PMCMC)}
##' \item \link[=abc]{approximate Bayesian computation (ABC)}
##' \item \link[=probe_matching]{probe-matching via synthetic likelihood}
##' \item \link[=nonlinear_forecasting]{nonlinear forecasting}
##' \item \link[=spectrum_matching]{power-spectrum matching}
##' \item \link[=bsmc2]{Liu-West Bayesian sequential Monte Carlo}
##' \item \link[=kalman]{Ensemble and ensemble-adjusted Kalman filters}
##' }
##'
##' Help pages detailing each estimation algorithm are provided.
##'
##' @name estimation_algorithms
##' @rdname estimation_algorithms
##' @family estimation_methods
##' @seealso \link[=basic_components]{basic model components},
##' \link[=workhorses]{workhorse functions},
##' \link[=elementary_algorithms]{elementary algorithms}.
##' 
NULL
