% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebola.R
\docType{data}
\name{ebola}
\alias{ebola}
\alias{ebolaWA2014}
\alias{ebolaModel}
\title{Ebola outbreak, West Africa, 2014-2016}
\usage{
ebolaModel(
  country = c("GIN", "LBR", "SLE"),
  data = NULL,
  timestep = 1/8,
  nstageE = 3L,
  R0 = 1.4,
  rho = 0.2,
  cfr = 0.7,
  k = 0,
  index_case = 10,
  incubation_period = 11.4,
  infectious_period = 7
)
}
\arguments{
\item{country}{ISO symbol for the country (GIN=Guinea, LBR=Liberia, SLE=Sierra Leone).}

\item{data}{if NULL, the situation report data (WHO Ebola Response Team 2014) for the appropriate country or region will be used.
Providing a dataset here will override this behavior.}

\item{timestep}{duration (in days) of Euler timestep for the simulations.}

\item{nstageE}{integer; number of incubation stages.}

\item{R0}{basic reproduction ratio}

\item{rho}{case reporting efficiency}

\item{cfr}{case fatality rate}

\item{k}{dispersion parameter (negative binomial \code{size} parameter)}

\item{index_case}{number of cases on day 0 (2014-04-01)}

\item{incubation_period, infectious_period}{mean duration (in days) of the incubation and infectious periods.}
}
\description{
Data and models for the 2014--2016 outbreak of Ebola virus disease in West Africa.
}
\details{
The data include monthly case counts and death reports derived from WHO situation reports, as reported by the U.S. CDC.
The models are described in King et al. (2015).

The data-cleaning script is included in the R source code file \file{ebola.R}.
}
\section{Model structure}{

The default incubation period is supposed to be Gamma distributed with shape parameter \code{nstageE} and mean 11.4 days and the case-fatality ratio (`cfr`) is taken to be 0.7 (cf. WHO Ebola Response Team 2014).
The discrete-time formula is used to calculate the corresponding \code{alpha} (cf. He et al. 2010).

The observation model is a hierarchical model for cases and deaths:
  \deqn{p(R_t, D_t| C_t) = p(R_t | C_t) p(D_t | C_t, R_t).}
Here, \eqn{p(R_t | C_t)} is negative binomial with mean \eqn{\rho C_t} and dispersion parameter \eqn{1/k};
\eqn{p(D_t | C_t, R_t)} is binomial with size \eqn{R_t} and probability equal to the case fatality rate \code{cfr}.
}

\examples{
if (require(ggplot2) && require(tidyr)) {

  data(ebolaWA2014)

  ebolaWA2014 \%>\%
    gather(variable,count,cases,deaths) \%>\%
    ggplot(aes(x=date,y=count,group=country,color=country))+
    geom_line()+
    facet_grid(variable~.,scales="free_y")+
    theme_bw()+
    theme(axis.text=element_text(angle=-90))

  ebolaWA2014 \%>\%
    gather(variable,count,cases,deaths) \%>\%
    ggplot(aes(x=date,y=count,group=variable,color=variable))+
    geom_line()+
    facet_grid(country~.,scales="free_y")+
    theme_bw()+
    theme(axis.text=element_text(angle=-90))

  plot(ebolaModel(country="SLE"))
  plot(ebolaModel(country="LBR"))
  plot(ebolaModel(country="GIN"))
}
}
\references{
\King2015

\WHO2014

\He2010
}
\seealso{
More data sets provided with \pkg{pomp}: 
\code{\link{blowflies}},
\code{\link{bsflu}},
\code{\link{childhood disease data}},
\code{\link{dacca}()},
\code{\link{parus}}

More examples provided with \pkg{pomp}: 
\code{\link{SIR models}},
\code{\link{blowflies}},
\code{\link{childhood disease data}},
\code{\link{dacca}()},
\code{\link{gompertz}()},
\code{\link{ou2}()},
\code{\link{pomp examples}},
\code{\link{ricker}()},
\code{\link{rw2}()},
\code{\link{verhulst}()}
}
\concept{pomp datasets}
\concept{pomp examples}
