% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mif2.R
\name{mif2}
\alias{mif2}
\alias{mif2,missing-method}
\alias{mif2,ANY-method}
\alias{mif2,data.frame-method}
\alias{mif2,pomp-method}
\alias{mif2,pfilterd_pomp-method}
\alias{mif2,mif2d_pomp-method}
\title{Iterated filtering: maximum likelihood by iterated, perturbed Bayes maps}
\usage{
\S4method{mif2}{data.frame}(
  data,
  Nmif = 1,
  rw.sd,
  cooling.type = c("geometric", "hyperbolic"),
  cooling.fraction.50,
  Np,
  params,
  rinit,
  rprocess,
  dmeasure,
  partrans,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{mif2}{pomp}(
  data,
  Nmif = 1,
  rw.sd,
  cooling.type = c("geometric", "hyperbolic"),
  cooling.fraction.50,
  Np,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{mif2}{pfilterd_pomp}(data, Nmif = 1, Np, ..., verbose = getOption("verbose", FALSE))

\S4method{mif2}{mif2d_pomp}(
  data,
  Nmif,
  rw.sd,
  cooling.type,
  cooling.fraction.50,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be coerced to an array with storage-mode \code{double}.}

\item{Nmif}{The number of filtering iterations to perform.}

\item{rw.sd}{specification of the magnitude of the random-walk perturbations that will be applied to some or all model parameters.
Parameters that are to be estimated should have positive perturbations specified here.
The specification is given using the \code{\link{rw_sd}} function, which creates a list of unevaluated expressions.
The latter are evaluated in a context where the model time variable is defined (as \code{time}).
The expression \code{ivp(s)} can be used in this context as shorthand for \preformatted{ifelse(time==time[1],s,0).}
Likewise, \code{ivp(s,lag)} is equivalent to \preformatted{ifelse(time==time[lag],s,0).}
See below for some examples.

The perturbations that are applied are normally distributed with the specified s.d.
If parameter transformations have been supplied, then the perturbations are applied on the transformed (estimation) scale.}

\item{cooling.type, cooling.fraction.50}{specifications for the cooling schedule,
i.e., the manner and rate with which the intensity of the parameter perturbations is reduced with successive filtering iterations.
\code{cooling.type} specifies the nature of the cooling schedule.
See below (under \dQuote{Specifying the perturbations}) for more detail.}

\item{Np}{the number of particles to use.
This may be specified as a single positive integer, in which case the same number of particles will be used at each timestep.
Alternatively, if one wishes the number of particles to vary across timesteps, one may specify \code{Np} either as a vector of positive integers of length \preformatted{length(time(object,t0=TRUE))} or as a function taking a positive integer argument.
In the latter case, \code{Np(k)} must be a single positive integer, representing the number of particles to be used at the \code{k}-th timestep:
\code{Np(0)} is the number of particles to use going from \code{timezero(object)} to \code{time(object)[1]},
\code{Np(1)}, from \code{timezero(object)} to \code{time(object)[1]},
and so on,
while when \code{T=length(time(object))}, \code{Np(T)} is the number of particles to sample at the end of the time-series.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess_spec]{rprocess specification for the documentation on these plugins}.}

\item{dmeasure}{evaluator of the measurement model density, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{dmeasure=NULL} removes the measurement density evaluator.
For more information, see \link[=dmeasure_spec]{dmeasure specification}.}

\item{partrans}{optional parameter transformations, constructed using \code{\link{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link{parameter_trans}}.
For more information, see \link[=parameter_trans]{parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{...}{additional arguments are passed to \code{\link{pomp}}.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
Upon successful completion, \code{mif2} returns an object of class
\sQuote{mif2d_pomp}.
}
\description{
An iterated filtering algorithm for estimating the parameters of a partially-observed Markov process.
Running \code{mif2} causes the algorithm to perform a specified number of particle-filter iterations.
At each iteration, the particle filter is performed on a perturbed version of the model, in which the parameters to be estimated are subjected to random perturbations at each observation.
This extra variability effectively smooths the likelihood surface and combats particle depletion by introducing diversity into particle population.
As the iterations progress, the magnitude of the perturbations is diminished according to a user-specified cooling schedule.
The algorithm is presented and justified in Ionides et al. (2015).
}
\section{Number of particles}{

If \code{Np} is anything other than a constant, the user must take care that the number of particles requested at the end of the time series matches that requested at the beginning.
In particular, if \code{T=length(time(object))}, then one should have \code{Np[1]==Np[T+1]} when \code{Np} is furnished as an integer vector and \code{Np(0)==Np(T)} when \code{Np} is furnished as a function.
}

\section{Methods}{

The following methods are available for such an object:
\describe{
\item{\code{\link{continue}}}{ picks up where \code{mif2} leaves off and performs more filtering iterations. }
\item{\code{\link{logLik}}}{ returns the so-called \dfn{mif log likelihood} which is the log likelihood of the perturbed model, not of the focal model itself.
To obtain the latter, it is advisable to run several \code{\link{pfilter}} operations on the result of a \code{mif2} computatation.}
\item{\code{\link{coef}}}{ extracts the point estimate }
\item{\code{\link{eff_sample_size}}}{ extracts the effective sample size of the final filtering iteration}
}
Various other methods can be applied, including all the methods applicable to a \code{\link[=pfilter]{pfilterd_pomp}} object and all other \pkg{pomp} estimation algorithms and diagnostic methods.
}

\section{Specifying the perturbations}{

The \code{rw_sd} function simply returns a list containing its arguments as unevaluated expressions.
These are then evaluated in a context containing the model \code{time} variable.
This allows for easy specification of the structure of the perturbations that are to be applied.
For example,
\preformatted{
    rw_sd(a=0.05, b=ifelse(time==time[1],0.2,0),
          c=ivp(0.2), d=ifelse(time==time[13],0.2,0),
          e=ivp(0.2,lag=13), f=ifelse(time<23,0.02,0))
}
results in perturbations of parameter \code{a} with s.d. 0.05 at every time step, while parameters \code{b} and \code{c} both get perturbations of s.d. 0.2 only just before the first observation.
Parameters \code{d} and \code{e}, by contrast, get perturbations of s.d.  0.2 only just before the thirteenth observation.
Finally, parameter \code{f} gets a random perturbation of size 0.02 before every observation falling before \eqn{t=23}.

On the \eqn{m}-th IF2 iteration, prior to time-point \eqn{n}, the \eqn{d}-th parameter is given a random increment normally distributed with mean \eqn{0} and standard deviation \eqn{c_{m,n} \sigma_{d,n}}{c[m,n] sigma[d,n]}, where \eqn{c} is the cooling schedule and \eqn{\sigma}{sigma} is specified using \code{rw_sd}, as described above.
Let \eqn{N} be the length of the time series and \eqn{\alpha=}{alpha=}\code{cooling.fraction.50}.
Then, when \code{cooling.type="geometric"}, we have \deqn{c_{m,n}=\alpha^{\frac{n-1+(m-1)N}{50N}}.}{c[m,n]=alpha^((n-1+(m-1)N)/(50N)).}
When \code{cooling.type="hyperbolic"}, we have \deqn{c_{m,n}=\frac{s+1}{s+n+(m-1)N},}{c[m,n]=(s+1)/(s+n+(m-1)N),} where \eqn{s} satisfies \deqn{\frac{s+1}{s+50N}=\alpha.}{(s+1)/(s+50N)=alpha.}
Thus, in either case, the perturbations at the end of 50 IF2 iterations are a fraction \eqn{\alpha}{alpha} smaller than they are at first.
}

\section{Re-running IF2 iterations}{

To re-run a sequence of IF2 iterations, one can use the \code{mif2} method on a \sQuote{mif2d_pomp} object.
By default, the same parameters used for the original IF2 run are re-used (except for \code{verbose}, the default of which is shown above).
If one does specify additional arguments, these will override the defaults.
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\references{
\Ionides2015
}
\seealso{
More on full-information (i.e., likelihood-based) methods:
\code{\link{bsmc2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{wpfilter}()}

More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond_logLik}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{kalman}},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{wpfilter}()}

More on \pkg{pomp} estimation algorithms:
\code{\link{abc}()},
\code{\link{bsmc2}()},
\code{\link{estimation_algorithms}},
\code{\link{nlf}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{probe_match}},
\code{\link{spect_match}}

More on maximization-based estimation methods:
\code{\link{nlf}},
\code{\link{probe_match}},
\code{\link{spect_match}},
\code{\link{traj_match}}
}
\author{
Aaron A. King, Edward L. Ionides, Dao Nguyen
}
\concept{estimation methods}
\concept{full-information methods}
\concept{methods based on maximization}
\concept{particle filter methods}
