% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traces.R
\name{traces}
\alias{traces}
\alias{traces,missing-method}
\alias{traces,ANY-method}
\alias{traces,mif2d_pomp-method}
\alias{traces,mif2List-method}
\alias{traces,abcd_pomp-method}
\alias{traces,abcList-method}
\alias{traces,pmcmcd_pomp-method}
\alias{traces,pmcmcList-method}
\title{Traces}
\usage{
\S4method{traces}{mif2d_pomp}(object, pars, transform = FALSE, ...)

\S4method{traces}{mif2List}(object, pars, ...)

\S4method{traces}{abcd_pomp}(object, pars, ...)

\S4method{traces}{abcList}(object, pars, ...)

\S4method{traces}{pmcmcd_pomp}(object, pars, ...)

\S4method{traces}{pmcmcList}(object, pars, ...)
}
\arguments{
\item{object}{an object of class extending \sQuote{pomp}, the result of the application of a parameter estimation algorithm}

\item{pars}{names of parameters}

\item{transform}{logical; should the traces be transformed back onto the natural scale?}

\item{\dots}{ignored or passed to the more primitive function}
}
\value{
When \code{object} is the result of a \code{\link{mif2}} calculation,
\code{traces(object, pars)} returns the traces of the parameters named in \code{pars}.
By default, the traces of all parameters are returned.
If \code{transform=TRUE}, the parameters are transformed from the natural scale to the estimation scale.

When \code{object} is a \sQuote{abcd_pomp}, \code{traces(object)}
extracts the traces as a \code{coda::mcmc}.

When \code{object} is a \sQuote{abcList}, \code{traces(object)}
extracts the traces as a \code{coda::mcmc.list}.

When \code{object} is a \sQuote{pmcmcd_pomp}, \code{traces(object)}
extracts the traces as a \code{coda::mcmc}.

When \code{object} is a \sQuote{pmcmcList}, \code{traces(object)}
extracts the traces as a \code{coda::mcmc.list}.
}
\description{
Retrieve the history of an iterative calculation.
}
\details{
Note that \code{\link{pmcmc}} does not currently support parameter transformations.
}
\seealso{
Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond_logLik}()},
\code{\link{covmat}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{timezero}()},
\code{\link{time}()}
}
\concept{extraction methods}
