% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfilter.R, R/objfun.R
\name{pfilter}
\alias{pfilter}
\alias{pfilter,ANY-method}
\alias{pfilter,missing-method}
\alias{pfilter,data.frame-method}
\alias{pfilter,pomp-method}
\alias{pfilter,pfilterd_pomp-method}
\alias{pfilter,objfun-method}
\title{Particle filter}
\usage{
\S4method{pfilter}{data.frame}(
  data,
  Np,
  params,
  rinit,
  rprocess,
  dmeasure,
  pred.mean = FALSE,
  pred.var = FALSE,
  filter.mean = FALSE,
  filter.traj = FALSE,
  save.states = c("no", "weighted", "unweighted", "FALSE", "TRUE"),
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{pfilter}{pomp}(
  data,
  Np,
  pred.mean = FALSE,
  pred.var = FALSE,
  filter.mean = FALSE,
  filter.traj = FALSE,
  save.states = c("no", "weighted", "unweighted", "FALSE", "TRUE"),
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{pfilter}{pfilterd_pomp}(data, Np, ..., verbose = getOption("verbose", FALSE))

\S4method{pfilter}{objfun}(data, ...)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be coerced to an array with storage-mode \code{double}.}

\item{Np}{the number of particles to use.
This may be specified as a single positive integer, in which case the same number of particles will be used at each timestep.
Alternatively, if one wishes the number of particles to vary across timesteps, one may specify \code{Np} either as a vector of positive integers of length \preformatted{length(time(object,t0=TRUE))} or as a function taking a positive integer argument.
In the latter case, \code{Np(k)} must be a single positive integer, representing the number of particles to be used at the \code{k}-th timestep:
\code{Np(0)} is the number of particles to use going from \code{timezero(object)} to \code{time(object)[1]},
\code{Np(1)}, from \code{timezero(object)} to \code{time(object)[1]},
and so on,
while when \code{T=length(time(object))}, \code{Np(T)} is the number of particles to sample at the end of the time-series.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess_spec]{rprocess specification for the documentation on these plugins}.}

\item{dmeasure}{evaluator of the measurement model density, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{dmeasure=NULL} removes the measurement density evaluator.
For more information, see \link[=dmeasure_spec]{dmeasure specification}.}

\item{pred.mean}{logical; if \code{TRUE}, the prediction means are calculated for the state variables and parameters.}

\item{pred.var}{logical; if \code{TRUE}, the prediction variances are calculated for the state variables and parameters.}

\item{filter.mean}{logical; if \code{TRUE}, the filtering means are calculated for the state variables and parameters.}

\item{filter.traj}{logical; if \code{TRUE}, a filtered trajectory is returned for the state variables and parameters.
See \code{\link{filter_traj}} for more information.}

\item{save.states}{character;
If \code{save.states="unweighted"}, the state-vector for each unweighted particle at each time is saved.
If \code{save.states="weighted"}, the state-vector for each weighted particle at each time is saved, along with the corresponding weight.
If \code{save.states="no"}, information on the latent states is not saved.
\code{"FALSE"} is a synonym for \code{"no"} and \code{"TRUE"} is a synonym for \code{"unweighted"}.
To retrieve the saved states, applying \code{\link{saved.states}} to the result of the \code{pfilter} computation.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
An object of class \sQuote{pfilterd_pomp}, which extends class \sQuote{pomp}.
Information can be extracted from this object using the methods documented below.
}
\description{
A plain vanilla sequential Monte Carlo (particle filter) algorithm.
Resampling is performed at each observation.
}
\section{Methods}{

\describe{
\item{\code{\link{logLik}}}{ the estimated log likelihood  }
\item{\code{\link{cond_logLik}}}{ the estimated conditional log likelihood }
\item{\code{\link{eff_sample_size}}}{
the (time-dependent) estimated effective sample size }
\item{\code{\link{pred_mean}}, \code{\link{pred_var}}}{ the mean and variance of the approximate prediction distribution }
\item{\code{\link{filter_mean}}}{ the mean of the filtering distribution }
\item{\code{\link{filter_traj}}}{
  retrieve one particle trajectory.
  Useful for building up the smoothing distribution.
}
\item{\code{\link{saved_states}}}{retrieve saved states}
\item{\code{\link{as.data.frame}}}{coerce to a data frame}
\item{\code{\link{plot}}}{diagnostic plots}
}
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\examples{
pf <- pfilter(gompertz(),Np=1000)	## use 1000 particles

plot(pf)
logLik(pf)
cond_logLik(pf)			## conditional log-likelihoods
eff_sample_size(pf)             ## effective sample size
logLik(pfilter(pf))      	## run it again with 1000 particles

## run it again with 2000 particles
pf <- pfilter(pf,Np=2000,filter.mean=TRUE,filter.traj=TRUE,save.states="weighted")
fm <- filter_mean(pf) ## extract the filtering means
ft <- filter_traj(pf) ## one draw from the smoothing distribution
ss <- saved_states(pf,format="d") ## the latent-state portion of each particle

as(pf,"data.frame") |> head()
}
\references{
\Arulampalam2002

\Bhadra2016
}
\seealso{
More on \pkg{pomp} elementary algorithms: 
\code{\link{elementary_algorithms}},
\code{\link{kalman}},
\code{\link{pomp-package}},
\code{\link{probe}()},
\code{\link{simulate}()},
\code{\link{spect}()},
\code{\link{trajectory}()},
\code{\link{wpfilter}()}

More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond_logLik}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_mean}()},
\code{\link{filter_traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pmcmc}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{wpfilter}()}

More on full-information (i.e., likelihood-based) methods:
\code{\link{bsmc2}()},
\code{\link{mif2}()},
\code{\link{pmcmc}()},
\code{\link{wpfilter}()}
}
\author{
Aaron A. King
}
\concept{elementary algorithms}
\concept{full-information methods}
\concept{particle filter methods}
