% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_mean.R
\docType{methods}
\name{filter_mean}
\alias{filter_mean}
\alias{filter_mean,ANY-method}
\alias{filter_mean,missing-method}
\alias{filter_mean,kalmand_pomp-method}
\alias{filter_mean,pfilterd_pomp-method}
\title{Filtering mean}
\usage{
\S4method{filter_mean}{kalmand_pomp}(object, vars, ..., format = c("array", "data.frame"))

\S4method{filter_mean}{pfilterd_pomp}(object, vars, ..., format = c("array", "data.frame"))
}
\arguments{
\item{object}{result of a filtering computation}

\item{vars}{optional character; names of variables}

\item{...}{ignored}

\item{format}{format of the returned object}
}
\description{
The mean of the filtering distribution
}
\details{
The filtering distribution is that of
\deqn{X(t_k) \vert Y(t_1)=y^*_1,\dots,Y(t_k)=y^*_k,}{Xk | Y1=y1*,\dots,Yk=yk*,}
where \eqn{X(t_k)}{Xk}, \eqn{Y(t_k)}{Yk} are the latent state and observable processes, respectively, and \eqn{y^*_t}{yt*} is the data, at time \eqn{t_k}{tk}.

The filtering mean is therefore the expectation of this distribution
\deqn{E[X(t_k) \vert Y(t_1)=y^*_1,\dots,Y(t_k)=y^*_k].}{E[Xk | Y1=y1*,\dots,Yk=yk*].}
}
\seealso{
More on sequential Monte Carlo methods: 
\code{\link{bsmc2}()},
\code{\link{cond_logLik}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{wpfilter}()}

Other extraction methods: 
\code{\link{coef}()},
\code{\link{cond_logLik}()},
\code{\link{covmat}()},
\code{\link{eff_sample_size}()},
\code{\link{filter_traj}()},
\code{\link{forecast}()},
\code{\link{logLik}},
\code{\link{obs}()},
\code{\link{pred_mean}()},
\code{\link{pred_var}()},
\code{\link{saved_states}()},
\code{\link{spy}()},
\code{\link{states}()},
\code{\link{summary}()},
\code{\link{time}()},
\code{\link{timezero}()},
\code{\link{traces}()}
}
\concept{extraction methods}
\concept{particle filter methods}
