% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbPool}
\alias{dbPool}
\title{Create a pool of database connections}
\usage{
dbPool(
  drv,
  ...,
  minSize = 1,
  maxSize = Inf,
  onCreate = NULL,
  idleTimeout = 60,
  validationInterval = 60,
  validateQuery = NULL
)
}
\arguments{
\item{drv}{A \link[DBI:DBIDriver-class]{DBI Driver}, e.g. \code{RSQLite::SQLite()},
\code{RPostgres::Postgres()}, \code{odbc::odbc()} etc.}

\item{...}{Arguments passed on to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}. These are used to
identify the database and provide needed authentication.}

\item{minSize, maxSize}{The minimum and maximum number of objects in the pool.}

\item{onCreate}{A function that takes a single argument, a connection,
and is called when the connection is created. Use this with
\code{\link[DBI:dbExecute]{DBI::dbExecute()}} to set default options on every connection created
by the pool.}

\item{idleTimeout}{Number of seconds to wait before destroying idle objects
(i.e. objects available for checkout over and above \code{minSize}).}

\item{validationInterval}{Number of seconds to wait between validating
objects that are available for checkout. These objects are validated
in the background to keep them alive.

To force objects to be validated on every checkout, set
\code{validationInterval = 0}.}

\item{validateQuery}{A simple query that can be used to verify that the
connetction is valid. If not provided, \code{dbPool()} will try a few common
options, but these don't work for all databases.}
}
\description{
\code{dbPool()} is a drop-in replacement for \code{\link[DBI:dbConnect]{DBI::dbConnect()}} that
provides a shared pool of connections that can automatically reconnect
to the database if needed.
}
\examples{
# You use a dbPool in the same way as a standard DBI connection
pool <- dbPool(RSQLite::SQLite())
pool

DBI::dbWriteTable(pool, "mtcars", mtcars)
dbGetQuery(pool, "SELECT * FROM mtcars LIMIT 4")

# Always close a pool when you're done using it
poolClose(pool)

# Using the RMySQL package
if (requireNamespace("RMySQL", quietly = TRUE)) {
  pool <- dbPool(
    drv = RMySQL::MySQL(),
    dbname = "shinydemo",
    host = "shiny-demo.csa7qlmguqrf.us-east-1.rds.amazonaws.com",
    username = "guest",
    password = "guest"
  )

  dbGetQuery(pool, "SELECT * from City LIMIT 5;")

  poolClose(pool)
}
}
